package io.fabric8.istio.api.networking.v1beta1;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Collection;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
public interface ServerFluent<A extends ServerFluent<A>> extends Fluent<A>{
  public String getBind();
  public A withBind(String bind);
  public Boolean hasBind();
  public String getDefaultEndpoint();
  public A withDefaultEndpoint(String defaultEndpoint);
  public Boolean hasDefaultEndpoint();
  public A addToHosts(int index,String item);
  public A setToHosts(int index,String item);
  public A addToHosts(java.lang.String... items);
  public A addAllToHosts(Collection<String> items);
  public A removeFromHosts(java.lang.String... items);
  public A removeAllFromHosts(Collection<String> items);
  public List<String> getHosts();
  public String getHost(int index);
  public String getFirstHost();
  public String getLastHost();
  public String getMatchingHost(Predicate<String> predicate);
  public Boolean hasMatchingHost(Predicate<String> predicate);
  public A withHosts(List<String> hosts);
  public A withHosts(java.lang.String... hosts);
  public Boolean hasHosts();
  public String getName();
  public A withName(String name);
  public Boolean hasName();
  
  /**
   * This method has been deprecated, please use method buildPort instead.
   * @return The buildable object.
   */
  @Deprecated
  public Port getPort();
  public Port buildPort();
  public A withPort(Port port);
  public Boolean hasPort();
  public A withNewPort(String name,Integer number,String protocol,Integer targetPort);
  public ServerFluent.PortNested<A> withNewPort();
  public ServerFluent.PortNested<A> withNewPortLike(Port item);
  public ServerFluent.PortNested<A> editPort();
  public ServerFluent.PortNested<A> editOrNewPort();
  public ServerFluent.PortNested<A> editOrNewPortLike(Port item);
  
  /**
   * This method has been deprecated, please use method buildTls instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServerTLSSettings getTls();
  public ServerTLSSettings buildTls();
  public A withTls(ServerTLSSettings tls);
  public Boolean hasTls();
  public ServerFluent.TlsNested<A> withNewTls();
  public ServerFluent.TlsNested<A> withNewTlsLike(ServerTLSSettings item);
  public ServerFluent.TlsNested<A> editTls();
  public ServerFluent.TlsNested<A> editOrNewTls();
  public ServerFluent.TlsNested<A> editOrNewTlsLike(ServerTLSSettings item);
  public interface PortNested<N> extends Nested<N>,PortFluent<ServerFluent.PortNested<N>>{
    public N and();
    public N endPort();
    
  }
  public interface TlsNested<N> extends Nested<N>,ServerTLSSettingsFluent<ServerFluent.TlsNested<N>>{
    public N and();
    public N endTls();
    
  }
  
}