package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RouteDestinationBuilder extends RouteDestinationFluentImpl<RouteDestinationBuilder> implements VisitableBuilder<RouteDestination,RouteDestinationBuilder>{
  public RouteDestinationBuilder() {
    this(false);
  }
  public RouteDestinationBuilder(Boolean validationEnabled) {
    this(new RouteDestination(), validationEnabled);
  }
  public RouteDestinationBuilder(RouteDestinationFluent<?> fluent) {
    this(fluent, false);
  }
  public RouteDestinationBuilder(RouteDestinationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RouteDestination(), validationEnabled);
  }
  public RouteDestinationBuilder(RouteDestinationFluent<?> fluent,RouteDestination instance) {
    this(fluent, instance, false);
  }
  public RouteDestinationBuilder(RouteDestinationFluent<?> fluent,RouteDestination instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withDestination(instance.getDestination());
      fluent.withWeight(instance.getWeight());
    }
    this.validationEnabled = validationEnabled; 
  }
  public RouteDestinationBuilder(RouteDestination instance) {
    this(instance,false);
  }
  public RouteDestinationBuilder(RouteDestination instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withDestination(instance.getDestination());
      this.withWeight(instance.getWeight());
    }
    this.validationEnabled = validationEnabled; 
  }
  RouteDestinationFluent<?> fluent;
  Boolean validationEnabled;
  public RouteDestination build() {
    RouteDestination buildable = new RouteDestination(fluent.getDestination(),fluent.getWeight());
    return buildable;
  }
  
}