package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LoadBalancerSettingsBuilder extends LoadBalancerSettingsFluentImpl<LoadBalancerSettingsBuilder> implements VisitableBuilder<LoadBalancerSettings,LoadBalancerSettingsBuilder>{
  public LoadBalancerSettingsBuilder() {
    this(false);
  }
  public LoadBalancerSettingsBuilder(Boolean validationEnabled) {
    this(new LoadBalancerSettings(), validationEnabled);
  }
  public LoadBalancerSettingsBuilder(LoadBalancerSettingsFluent<?> fluent) {
    this(fluent, false);
  }
  public LoadBalancerSettingsBuilder(LoadBalancerSettingsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LoadBalancerSettings(), validationEnabled);
  }
  public LoadBalancerSettingsBuilder(LoadBalancerSettingsFluent<?> fluent,LoadBalancerSettings instance) {
    this(fluent, instance, false);
  }
  public LoadBalancerSettingsBuilder(LoadBalancerSettingsFluent<?> fluent,LoadBalancerSettings instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withLbPolicy(instance.getLbPolicy());
      fluent.withLocalityLbSetting(instance.getLocalityLbSetting());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LoadBalancerSettingsBuilder(LoadBalancerSettings instance) {
    this(instance,false);
  }
  public LoadBalancerSettingsBuilder(LoadBalancerSettings instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withLbPolicy(instance.getLbPolicy());
      this.withLocalityLbSetting(instance.getLocalityLbSetting());
    }
    this.validationEnabled = validationEnabled; 
  }
  LoadBalancerSettingsFluent<?> fluent;
  Boolean validationEnabled;
  public LoadBalancerSettings build() {
    LoadBalancerSettings buildable = new LoadBalancerSettings(fluent.getLbPolicy(),fluent.getLocalityLbSetting());
    return buildable;
  }
  
}