package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class IstioEgressListenerBuilder extends IstioEgressListenerFluentImpl<IstioEgressListenerBuilder> implements VisitableBuilder<IstioEgressListener,IstioEgressListenerBuilder>{
  public IstioEgressListenerBuilder() {
    this(false);
  }
  public IstioEgressListenerBuilder(Boolean validationEnabled) {
    this(new IstioEgressListener(), validationEnabled);
  }
  public IstioEgressListenerBuilder(IstioEgressListenerFluent<?> fluent) {
    this(fluent, false);
  }
  public IstioEgressListenerBuilder(IstioEgressListenerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new IstioEgressListener(), validationEnabled);
  }
  public IstioEgressListenerBuilder(IstioEgressListenerFluent<?> fluent,IstioEgressListener instance) {
    this(fluent, instance, false);
  }
  public IstioEgressListenerBuilder(IstioEgressListenerFluent<?> fluent,IstioEgressListener instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBind(instance.getBind());
      fluent.withCaptureMode(instance.getCaptureMode());
      fluent.withHosts(instance.getHosts());
      fluent.withPort(instance.getPort());
    }
    this.validationEnabled = validationEnabled; 
  }
  public IstioEgressListenerBuilder(IstioEgressListener instance) {
    this(instance,false);
  }
  public IstioEgressListenerBuilder(IstioEgressListener instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBind(instance.getBind());
      this.withCaptureMode(instance.getCaptureMode());
      this.withHosts(instance.getHosts());
      this.withPort(instance.getPort());
    }
    this.validationEnabled = validationEnabled; 
  }
  IstioEgressListenerFluent<?> fluent;
  Boolean validationEnabled;
  public IstioEgressListener build() {
    IstioEgressListener buildable = new IstioEgressListener(fluent.getBind(),fluent.getCaptureMode(),fluent.getHosts(),fluent.getPort());
    return buildable;
  }
  
}