package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class DestinationRuleSpecFluentImpl<A extends DestinationRuleSpecFluent<A>> extends BaseFluent<A> implements DestinationRuleSpecFluent<A>{
  public DestinationRuleSpecFluentImpl() {
  }
  public DestinationRuleSpecFluentImpl(DestinationRuleSpec instance) {
    if (instance != null) {
      this.withExportTo(instance.getExportTo());
      this.withHost(instance.getHost());
      this.withSubsets(instance.getSubsets());
      this.withTrafficPolicy(instance.getTrafficPolicy());
    }
  }
  private List<String> exportTo = new ArrayList<String>();
  private String host;
  private ArrayList<SubsetBuilder> subsets = new ArrayList<SubsetBuilder>();
  private TrafficPolicyBuilder trafficPolicy;
  public A addToExportTo(int index,String item) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    this.exportTo.add(index, item);
    return (A)this;
  }
  public A setToExportTo(int index,String item) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    this.exportTo.set(index, item); return (A)this;
  }
  public A addToExportTo(java.lang.String... items) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    for (String item : items) {this.exportTo.add(item);} return (A)this;
  }
  public A addAllToExportTo(Collection<String> items) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    for (String item : items) {this.exportTo.add(item);} return (A)this;
  }
  public A removeFromExportTo(java.lang.String... items) {
    for (String item : items) {if (this.exportTo!= null){ this.exportTo.remove(item);}} return (A)this;
  }
  public A removeAllFromExportTo(Collection<String> items) {
    for (String item : items) {if (this.exportTo!= null){ this.exportTo.remove(item);}} return (A)this;
  }
  public List<String> getExportTo() {
    return this.exportTo;
  }
  public String getExportTo(int index) {
    return this.exportTo.get(index);
  }
  public String getFirstExportTo() {
    return this.exportTo.get(0);
  }
  public String getLastExportTo() {
    return this.exportTo.get(exportTo.size() - 1);
  }
  public String getMatchingExportTo(Predicate<String> predicate) {
    for (String item: exportTo) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingExportTo(Predicate<String> predicate) {
    for (String item: exportTo) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExportTo(List<String> exportTo) {
    if (exportTo != null) {this.exportTo = new ArrayList(); for (String item : exportTo){this.addToExportTo(item);}} else { this.exportTo = null;} return (A) this;
  }
  public A withExportTo(java.lang.String... exportTo) {
    if (this.exportTo != null) {this.exportTo.clear(); _visitables.remove("exportTo"); }
    if (exportTo != null) {for (String item :exportTo){ this.addToExportTo(item);}} return (A) this;
  }
  public Boolean hasExportTo() {
    return exportTo != null && !exportTo.isEmpty();
  }
  public String getHost() {
    return this.host;
  }
  public A withHost(String host) {
    this.host=host; return (A) this;
  }
  public Boolean hasHost() {
    return this.host != null;
  }
  public A addToSubsets(int index,Subset item) {
    if (this.subsets == null) {this.subsets = new ArrayList<SubsetBuilder>();}
    SubsetBuilder builder = new SubsetBuilder(item);
    if (index < 0 || index >= subsets.size()) { _visitables.get("subsets").add(builder); subsets.add(builder); } else { _visitables.get("subsets").add(index, builder); subsets.add(index, builder);}
    return (A)this;
  }
  public A setToSubsets(int index,Subset item) {
    if (this.subsets == null) {this.subsets = new ArrayList<SubsetBuilder>();}
    SubsetBuilder builder = new SubsetBuilder(item);
    if (index < 0 || index >= subsets.size()) { _visitables.get("subsets").add(builder); subsets.add(builder); } else { _visitables.get("subsets").set(index, builder); subsets.set(index, builder);}
    return (A)this;
  }
  public A addToSubsets(io.fabric8.istio.api.networking.v1beta1.Subset... items) {
    if (this.subsets == null) {this.subsets = new ArrayList<SubsetBuilder>();}
    for (Subset item : items) {SubsetBuilder builder = new SubsetBuilder(item);_visitables.get("subsets").add(builder);this.subsets.add(builder);} return (A)this;
  }
  public A addAllToSubsets(Collection<Subset> items) {
    if (this.subsets == null) {this.subsets = new ArrayList<SubsetBuilder>();}
    for (Subset item : items) {SubsetBuilder builder = new SubsetBuilder(item);_visitables.get("subsets").add(builder);this.subsets.add(builder);} return (A)this;
  }
  public A removeFromSubsets(io.fabric8.istio.api.networking.v1beta1.Subset... items) {
    for (Subset item : items) {SubsetBuilder builder = new SubsetBuilder(item);_visitables.get("subsets").remove(builder);if (this.subsets != null) {this.subsets.remove(builder);}} return (A)this;
  }
  public A removeAllFromSubsets(Collection<Subset> items) {
    for (Subset item : items) {SubsetBuilder builder = new SubsetBuilder(item);_visitables.get("subsets").remove(builder);if (this.subsets != null) {this.subsets.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromSubsets(Predicate<SubsetBuilder> predicate) {
    if (subsets == null) return (A) this;
    final Iterator<SubsetBuilder> each = subsets.iterator();
    final List visitables = _visitables.get("subsets");
    while (each.hasNext()) {
      SubsetBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildSubsets instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Subset> getSubsets() {
    return subsets != null ? build(subsets) : null;
  }
  public List<Subset> buildSubsets() {
    return subsets != null ? build(subsets) : null;
  }
  public Subset buildSubset(int index) {
    return this.subsets.get(index).build();
  }
  public Subset buildFirstSubset() {
    return this.subsets.get(0).build();
  }
  public Subset buildLastSubset() {
    return this.subsets.get(subsets.size() - 1).build();
  }
  public Subset buildMatchingSubset(Predicate<SubsetBuilder> predicate) {
    for (SubsetBuilder item: subsets) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingSubset(Predicate<SubsetBuilder> predicate) {
    for (SubsetBuilder item: subsets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubsets(List<Subset> subsets) {
    if (this.subsets != null) { _visitables.get("subsets").clear();}
    if (subsets != null) {this.subsets = new ArrayList(); for (Subset item : subsets){this.addToSubsets(item);}} else { this.subsets = null;} return (A) this;
  }
  public A withSubsets(io.fabric8.istio.api.networking.v1beta1.Subset... subsets) {
    if (this.subsets != null) {this.subsets.clear(); _visitables.remove("subsets"); }
    if (subsets != null) {for (Subset item :subsets){ this.addToSubsets(item);}} return (A) this;
  }
  public Boolean hasSubsets() {
    return subsets != null && !subsets.isEmpty();
  }
  public DestinationRuleSpecFluentImpl.SubsetsNested<A> addNewSubset() {
    return new DestinationRuleSpecFluentImpl.SubsetsNestedImpl();
  }
  public DestinationRuleSpecFluentImpl.SubsetsNested<A> addNewSubsetLike(Subset item) {
    return new DestinationRuleSpecFluentImpl.SubsetsNestedImpl(-1, item);
  }
  public DestinationRuleSpecFluentImpl.SubsetsNested<A> setNewSubsetLike(int index,Subset item) {
    return new DestinationRuleSpecFluentImpl.SubsetsNestedImpl(index, item);
  }
  public DestinationRuleSpecFluentImpl.SubsetsNested<A> editSubset(int index) {
    if (subsets.size() <= index) throw new RuntimeException("Can't edit subsets. Index exceeds size.");
    return setNewSubsetLike(index, buildSubset(index));
  }
  public DestinationRuleSpecFluentImpl.SubsetsNested<A> editFirstSubset() {
    if (subsets.size() == 0) throw new RuntimeException("Can't edit first subsets. The list is empty.");
    return setNewSubsetLike(0, buildSubset(0));
  }
  public DestinationRuleSpecFluentImpl.SubsetsNested<A> editLastSubset() {
    int index = subsets.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last subsets. The list is empty.");
    return setNewSubsetLike(index, buildSubset(index));
  }
  public DestinationRuleSpecFluentImpl.SubsetsNested<A> editMatchingSubset(Predicate<SubsetBuilder> predicate) {
    int index = -1;
    for (int i=0;i<subsets.size();i++) { 
    if (predicate.test(subsets.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching subsets. No match found.");
    return setNewSubsetLike(index, buildSubset(index));
  }
  
  /**
   * This method has been deprecated, please use method buildTrafficPolicy instead.
   * @return The buildable object.
   */
  @Deprecated
  public TrafficPolicy getTrafficPolicy() {
    return this.trafficPolicy!=null ?this.trafficPolicy.build():null;
  }
  public TrafficPolicy buildTrafficPolicy() {
    return this.trafficPolicy!=null ?this.trafficPolicy.build():null;
  }
  public A withTrafficPolicy(TrafficPolicy trafficPolicy) {
    _visitables.get("trafficPolicy").remove(this.trafficPolicy);
    if (trafficPolicy!=null){ this.trafficPolicy= new TrafficPolicyBuilder(trafficPolicy); _visitables.get("trafficPolicy").add(this.trafficPolicy);} else { this.trafficPolicy = null; _visitables.get("trafficPolicy").remove(this.trafficPolicy); } return (A) this;
  }
  public Boolean hasTrafficPolicy() {
    return this.trafficPolicy != null;
  }
  public DestinationRuleSpecFluentImpl.TrafficPolicyNested<A> withNewTrafficPolicy() {
    return new DestinationRuleSpecFluentImpl.TrafficPolicyNestedImpl();
  }
  public DestinationRuleSpecFluentImpl.TrafficPolicyNested<A> withNewTrafficPolicyLike(TrafficPolicy item) {
    return new DestinationRuleSpecFluentImpl.TrafficPolicyNestedImpl(item);
  }
  public DestinationRuleSpecFluentImpl.TrafficPolicyNested<A> editTrafficPolicy() {
    return withNewTrafficPolicyLike(getTrafficPolicy());
  }
  public DestinationRuleSpecFluentImpl.TrafficPolicyNested<A> editOrNewTrafficPolicy() {
    return withNewTrafficPolicyLike(getTrafficPolicy() != null ? getTrafficPolicy(): new TrafficPolicyBuilder().build());
  }
  public DestinationRuleSpecFluentImpl.TrafficPolicyNested<A> editOrNewTrafficPolicyLike(TrafficPolicy item) {
    return withNewTrafficPolicyLike(getTrafficPolicy() != null ? getTrafficPolicy(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    DestinationRuleSpecFluentImpl that = (DestinationRuleSpecFluentImpl) o;
    if (!java.util.Objects.equals(exportTo, that.exportTo)) return false;

    if (!java.util.Objects.equals(host, that.host)) return false;

    if (!java.util.Objects.equals(subsets, that.subsets)) return false;

    if (!java.util.Objects.equals(trafficPolicy, that.trafficPolicy)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(exportTo,  host,  subsets,  trafficPolicy,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (exportTo != null && !exportTo.isEmpty()) { sb.append("exportTo:"); sb.append(exportTo + ","); }
    if (host != null) { sb.append("host:"); sb.append(host + ","); }
    if (subsets != null) { sb.append("subsets:"); sb.append(subsets + ","); }
    if (trafficPolicy != null) { sb.append("trafficPolicy:"); sb.append(trafficPolicy); }
    sb.append("}");
    return sb.toString();
  }
  class SubsetsNestedImpl<N> extends SubsetFluentImpl<DestinationRuleSpecFluentImpl.SubsetsNested<N>> implements DestinationRuleSpecFluentImpl.SubsetsNested<N>,Nested<N>{
    SubsetsNestedImpl(int index,Subset item) {
      this.index = index;
      this.builder = new SubsetBuilder(this, item);
    }
    SubsetsNestedImpl() {
      this.index = -1;
      this.builder = new SubsetBuilder(this);
    }
    SubsetBuilder builder;
    int index;
    public N and() {
      return (N) DestinationRuleSpecFluentImpl.this.setToSubsets(index,builder.build());
    }
    public N endSubset() {
      return and();
    }
    
  }
  class TrafficPolicyNestedImpl<N> extends TrafficPolicyFluentImpl<DestinationRuleSpecFluentImpl.TrafficPolicyNested<N>> implements DestinationRuleSpecFluentImpl.TrafficPolicyNested<N>,Nested<N>{
    TrafficPolicyNestedImpl(TrafficPolicy item) {
      this.builder = new TrafficPolicyBuilder(this, item);
    }
    TrafficPolicyNestedImpl() {
      this.builder = new TrafficPolicyBuilder(this);
    }
    TrafficPolicyBuilder builder;
    public N and() {
      return (N) DestinationRuleSpecFluentImpl.this.withTrafficPolicy(builder.build());
    }
    public N endTrafficPolicy() {
      return and();
    }
    
  }
  
}