package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JWTHeaderBuilder extends JWTHeaderFluentImpl<JWTHeaderBuilder> implements VisitableBuilder<JWTHeader,JWTHeaderBuilder>{
  public JWTHeaderBuilder() {
    this(false);
  }
  public JWTHeaderBuilder(Boolean validationEnabled) {
    this(new JWTHeader(), validationEnabled);
  }
  public JWTHeaderBuilder(JWTHeaderFluent<?> fluent) {
    this(fluent, false);
  }
  public JWTHeaderBuilder(JWTHeaderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JWTHeader(), validationEnabled);
  }
  public JWTHeaderBuilder(JWTHeaderFluent<?> fluent,JWTHeader instance) {
    this(fluent, instance, false);
  }
  public JWTHeaderBuilder(JWTHeaderFluent<?> fluent,JWTHeader instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withName(instance.getName());
      fluent.withPrefix(instance.getPrefix());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JWTHeaderBuilder(JWTHeader instance) {
    this(instance,false);
  }
  public JWTHeaderBuilder(JWTHeader instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withName(instance.getName());
      this.withPrefix(instance.getPrefix());
    }
    this.validationEnabled = validationEnabled; 
  }
  JWTHeaderFluent<?> fluent;
  Boolean validationEnabled;
  public JWTHeader build() {
    JWTHeader buildable = new JWTHeader(fluent.getName(),fluent.getPrefix());
    return buildable;
  }
  
}