package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelector;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorBuilder;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorFluentImpl;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AuthorizationPolicySpecFluentImpl<A extends AuthorizationPolicySpecFluent<A>> extends BaseFluent<A> implements AuthorizationPolicySpecFluent<A>{
  public AuthorizationPolicySpecFluentImpl() {
  }
  public AuthorizationPolicySpecFluentImpl(AuthorizationPolicySpec instance) {
    if (instance != null) {
      this.withActionDetail(instance.getActionDetail());
      this.withAction(instance.getAction());
      this.withRules(instance.getRules());
      this.withSelector(instance.getSelector());
    }
  }
  private VisitableBuilder<? extends IsAuthorizationPolicyActionDetail,?> actionDetail;
  private AuthorizationPolicyAction action;
  private ArrayList<RuleBuilder> rules = new ArrayList<RuleBuilder>();
  private WorkloadSelectorBuilder selector;
  
  /**
   * This method has been deprecated, please use method buildActionDetail instead.
   * @return The buildable object.
   */
  @Deprecated
  public IsAuthorizationPolicyActionDetail getActionDetail() {
    return this.actionDetail!=null?this.actionDetail.build():null;
  }
  public IsAuthorizationPolicyActionDetail buildActionDetail() {
    return this.actionDetail!=null?this.actionDetail.build():null;
  }
  public A withActionDetail(IsAuthorizationPolicyActionDetail actionDetail) {
    if (actionDetail==null){ this.actionDetail = null; _visitables.remove("actionDetail"); return (A) this;}
    if (actionDetail instanceof AuthorizationPolicyProvider){ this.actionDetail= new AuthorizationPolicyProviderBuilder((AuthorizationPolicyProvider)actionDetail); _visitables.get("actionDetail").clear(); _visitables.get("actionDetail").add(this.actionDetail);}
    VisitableBuilder<? extends IsAuthorizationPolicyActionDetail,?> builder = builderOf(actionDetail); _visitables.get("actionDetail").clear();_visitables.get("actionDetail").add(builder);this.actionDetail = builder;
    return (A) this;
  }
  public Boolean hasActionDetail() {
    return this.actionDetail != null;
  }
  public A withAuthorizationPolicyProviderActionDetail(AuthorizationPolicyProvider authorizationPolicyProviderActionDetail) {
    _visitables.get("actionDetail").remove(this.actionDetail);
    if (authorizationPolicyProviderActionDetail!=null){ this.actionDetail= new AuthorizationPolicyProviderBuilder(authorizationPolicyProviderActionDetail); _visitables.get("actionDetail").add(this.actionDetail);} else { this.actionDetail = null; _visitables.get("actionDetail").remove(this.actionDetail); } return (A) this;
  }
  public AuthorizationPolicySpecFluentImpl.AuthorizationPolicyProviderActionDetailNested<A> withNewAuthorizationPolicyProviderActionDetail() {
    return new AuthorizationPolicySpecFluentImpl.AuthorizationPolicyProviderActionDetailNestedImpl();
  }
  public AuthorizationPolicySpecFluentImpl.AuthorizationPolicyProviderActionDetailNested<A> withNewAuthorizationPolicyProviderActionDetailLike(AuthorizationPolicyProvider item) {
    return new AuthorizationPolicySpecFluentImpl.AuthorizationPolicyProviderActionDetailNestedImpl(item);
  }
  public AuthorizationPolicyAction getAction() {
    return this.action;
  }
  public A withAction(AuthorizationPolicyAction action) {
    this.action=action; return (A) this;
  }
  public Boolean hasAction() {
    return this.action != null;
  }
  public A addToRules(int index,Rule item) {
    if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
    RuleBuilder builder = new RuleBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").add(index, builder); rules.add(index, builder);}
    return (A)this;
  }
  public A setToRules(int index,Rule item) {
    if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
    RuleBuilder builder = new RuleBuilder(item);
    if (index < 0 || index >= rules.size()) { _visitables.get("rules").add(builder); rules.add(builder); } else { _visitables.get("rules").set(index, builder); rules.set(index, builder);}
    return (A)this;
  }
  public A addToRules(io.fabric8.istio.api.security.v1beta1.Rule... items) {
    if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
    for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A addAllToRules(Collection<Rule> items) {
    if (this.rules == null) {this.rules = new ArrayList<RuleBuilder>();}
    for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").add(builder);this.rules.add(builder);} return (A)this;
  }
  public A removeFromRules(io.fabric8.istio.api.security.v1beta1.Rule... items) {
    for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeAllFromRules(Collection<Rule> items) {
    for (Rule item : items) {RuleBuilder builder = new RuleBuilder(item);_visitables.get("rules").remove(builder);if (this.rules != null) {this.rules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromRules(Predicate<RuleBuilder> predicate) {
    if (rules == null) return (A) this;
    final Iterator<RuleBuilder> each = rules.iterator();
    final List visitables = _visitables.get("rules");
    while (each.hasNext()) {
      RuleBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildRules instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Rule> getRules() {
    return rules != null ? build(rules) : null;
  }
  public List<Rule> buildRules() {
    return rules != null ? build(rules) : null;
  }
  public Rule buildRule(int index) {
    return this.rules.get(index).build();
  }
  public Rule buildFirstRule() {
    return this.rules.get(0).build();
  }
  public Rule buildLastRule() {
    return this.rules.get(rules.size() - 1).build();
  }
  public Rule buildMatchingRule(Predicate<RuleBuilder> predicate) {
    for (RuleBuilder item: rules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingRule(Predicate<RuleBuilder> predicate) {
    for (RuleBuilder item: rules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withRules(List<Rule> rules) {
    if (this.rules != null) { _visitables.get("rules").clear();}
    if (rules != null) {this.rules = new ArrayList(); for (Rule item : rules){this.addToRules(item);}} else { this.rules = null;} return (A) this;
  }
  public A withRules(io.fabric8.istio.api.security.v1beta1.Rule... rules) {
    if (this.rules != null) {this.rules.clear(); _visitables.remove("rules"); }
    if (rules != null) {for (Rule item :rules){ this.addToRules(item);}} return (A) this;
  }
  public Boolean hasRules() {
    return rules != null && !rules.isEmpty();
  }
  public AuthorizationPolicySpecFluentImpl.RulesNested<A> addNewRule() {
    return new AuthorizationPolicySpecFluentImpl.RulesNestedImpl();
  }
  public AuthorizationPolicySpecFluentImpl.RulesNested<A> addNewRuleLike(Rule item) {
    return new AuthorizationPolicySpecFluentImpl.RulesNestedImpl(-1, item);
  }
  public AuthorizationPolicySpecFluentImpl.RulesNested<A> setNewRuleLike(int index,Rule item) {
    return new AuthorizationPolicySpecFluentImpl.RulesNestedImpl(index, item);
  }
  public AuthorizationPolicySpecFluentImpl.RulesNested<A> editRule(int index) {
    if (rules.size() <= index) throw new RuntimeException("Can't edit rules. Index exceeds size.");
    return setNewRuleLike(index, buildRule(index));
  }
  public AuthorizationPolicySpecFluentImpl.RulesNested<A> editFirstRule() {
    if (rules.size() == 0) throw new RuntimeException("Can't edit first rules. The list is empty.");
    return setNewRuleLike(0, buildRule(0));
  }
  public AuthorizationPolicySpecFluentImpl.RulesNested<A> editLastRule() {
    int index = rules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last rules. The list is empty.");
    return setNewRuleLike(index, buildRule(index));
  }
  public AuthorizationPolicySpecFluentImpl.RulesNested<A> editMatchingRule(Predicate<RuleBuilder> predicate) {
    int index = -1;
    for (int i=0;i<rules.size();i++) { 
    if (predicate.test(rules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching rules. No match found.");
    return setNewRuleLike(index, buildRule(index));
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public WorkloadSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public WorkloadSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(WorkloadSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new WorkloadSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public AuthorizationPolicySpecFluentImpl.TypeSelectorNested<A> withNewTypeSelector() {
    return new AuthorizationPolicySpecFluentImpl.TypeSelectorNestedImpl();
  }
  public AuthorizationPolicySpecFluentImpl.TypeSelectorNested<A> withNewSelectorLike(WorkloadSelector item) {
    return new AuthorizationPolicySpecFluentImpl.TypeSelectorNestedImpl(item);
  }
  public AuthorizationPolicySpecFluentImpl.TypeSelectorNested<A> editTypeSelector() {
    return withNewSelectorLike(getSelector());
  }
  public AuthorizationPolicySpecFluentImpl.TypeSelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new WorkloadSelectorBuilder().build());
  }
  public AuthorizationPolicySpecFluentImpl.TypeSelectorNested<A> editOrNewSelectorLike(WorkloadSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AuthorizationPolicySpecFluentImpl that = (AuthorizationPolicySpecFluentImpl) o;
    if (!java.util.Objects.equals(actionDetail, that.actionDetail)) return false;

    if (!java.util.Objects.equals(action, that.action)) return false;

    if (!java.util.Objects.equals(rules, that.rules)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(actionDetail,  action,  rules,  selector,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (actionDetail != null) { sb.append("actionDetail:"); sb.append(actionDetail + ","); }
    if (action != null) { sb.append("action:"); sb.append(action + ","); }
    if (rules != null) { sb.append("rules:"); sb.append(rules + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector); }
    sb.append("}");
    return sb.toString();
  }
  class AuthorizationPolicyProviderActionDetailNestedImpl<N> extends AuthorizationPolicyProviderFluentImpl<AuthorizationPolicySpecFluentImpl.AuthorizationPolicyProviderActionDetailNested<N>> implements AuthorizationPolicySpecFluentImpl.AuthorizationPolicyProviderActionDetailNested<N>,Nested<N>{
    AuthorizationPolicyProviderActionDetailNestedImpl(AuthorizationPolicyProvider item) {
      this.builder = new AuthorizationPolicyProviderBuilder(this, item);
    }
    AuthorizationPolicyProviderActionDetailNestedImpl() {
      this.builder = new AuthorizationPolicyProviderBuilder(this);
    }
    AuthorizationPolicyProviderBuilder builder;
    public N and() {
      return (N) AuthorizationPolicySpecFluentImpl.this.withActionDetail(builder.build());
    }
    public N endAuthorizationPolicyProviderActionDetail() {
      return and();
    }
    
  }
  class RulesNestedImpl<N> extends RuleFluentImpl<AuthorizationPolicySpecFluentImpl.RulesNested<N>> implements AuthorizationPolicySpecFluentImpl.RulesNested<N>,Nested<N>{
    RulesNestedImpl(int index,Rule item) {
      this.index = index;
      this.builder = new RuleBuilder(this, item);
    }
    RulesNestedImpl() {
      this.index = -1;
      this.builder = new RuleBuilder(this);
    }
    RuleBuilder builder;
    int index;
    public N and() {
      return (N) AuthorizationPolicySpecFluentImpl.this.setToRules(index,builder.build());
    }
    public N endRule() {
      return and();
    }
    
  }
  class TypeSelectorNestedImpl<N> extends WorkloadSelectorFluentImpl<AuthorizationPolicySpecFluentImpl.TypeSelectorNested<N>> implements AuthorizationPolicySpecFluentImpl.TypeSelectorNested<N>,Nested<N>{
    TypeSelectorNestedImpl(WorkloadSelector item) {
      this.builder = new WorkloadSelectorBuilder(this, item);
    }
    TypeSelectorNestedImpl() {
      this.builder = new WorkloadSelectorBuilder(this);
    }
    WorkloadSelectorBuilder builder;
    public N and() {
      return (N) AuthorizationPolicySpecFluentImpl.this.withSelector(builder.build());
    }
    public N endTypeSelector() {
      return and();
    }
    
  }
  
}