package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class OutlierDetectionBuilder extends OutlierDetectionFluentImpl<OutlierDetectionBuilder> implements VisitableBuilder<OutlierDetection,OutlierDetectionBuilder>{
  public OutlierDetectionBuilder() {
    this(false);
  }
  public OutlierDetectionBuilder(Boolean validationEnabled) {
    this(new OutlierDetection(), validationEnabled);
  }
  public OutlierDetectionBuilder(OutlierDetectionFluent<?> fluent) {
    this(fluent, false);
  }
  public OutlierDetectionBuilder(OutlierDetectionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new OutlierDetection(), validationEnabled);
  }
  public OutlierDetectionBuilder(OutlierDetectionFluent<?> fluent,OutlierDetection instance) {
    this(fluent, instance, false);
  }
  public OutlierDetectionBuilder(OutlierDetectionFluent<?> fluent,OutlierDetection instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withBaseEjectionTime(instance.getBaseEjectionTime());
      fluent.withConsecutive5xxErrors(instance.getConsecutive5xxErrors());
      fluent.withConsecutiveErrors(instance.getConsecutiveErrors());
      fluent.withConsecutiveGatewayErrors(instance.getConsecutiveGatewayErrors());
      fluent.withConsecutiveLocalOriginFailures(instance.getConsecutiveLocalOriginFailures());
      fluent.withInterval(instance.getInterval());
      fluent.withMaxEjectionPercent(instance.getMaxEjectionPercent());
      fluent.withMinHealthPercent(instance.getMinHealthPercent());
      fluent.withSplitExternalLocalOriginErrors(instance.getSplitExternalLocalOriginErrors());
    }
    this.validationEnabled = validationEnabled; 
  }
  public OutlierDetectionBuilder(OutlierDetection instance) {
    this(instance,false);
  }
  public OutlierDetectionBuilder(OutlierDetection instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withBaseEjectionTime(instance.getBaseEjectionTime());
      this.withConsecutive5xxErrors(instance.getConsecutive5xxErrors());
      this.withConsecutiveErrors(instance.getConsecutiveErrors());
      this.withConsecutiveGatewayErrors(instance.getConsecutiveGatewayErrors());
      this.withConsecutiveLocalOriginFailures(instance.getConsecutiveLocalOriginFailures());
      this.withInterval(instance.getInterval());
      this.withMaxEjectionPercent(instance.getMaxEjectionPercent());
      this.withMinHealthPercent(instance.getMinHealthPercent());
      this.withSplitExternalLocalOriginErrors(instance.getSplitExternalLocalOriginErrors());
    }
    this.validationEnabled = validationEnabled; 
  }
  OutlierDetectionFluent<?> fluent;
  Boolean validationEnabled;
  public OutlierDetection build() {
    OutlierDetection buildable = new OutlierDetection(fluent.getBaseEjectionTime(),fluent.getConsecutive5xxErrors(),fluent.getConsecutiveErrors(),fluent.getConsecutiveGatewayErrors(),fluent.getConsecutiveLocalOriginFailures(),fluent.getInterval(),fluent.getMaxEjectionPercent(),fluent.getMinHealthPercent(),fluent.getSplitExternalLocalOriginErrors());
    return buildable;
  }
  
}