package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.istio.api.meta.v1alpha1.IstioStatus;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class GatewayFluentImpl<A extends GatewayFluent<A>> extends BaseFluent<A> implements GatewayFluent<A>{
  public GatewayFluentImpl() {
  }
  public GatewayFluentImpl(Gateway instance) {
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
    }
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private GatewaySpecBuilder spec;
  private IstioStatus status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public GatewayFluentImpl.MetadataNested<A> withNewMetadata() {
    return new GatewayFluentImpl.MetadataNestedImpl();
  }
  public GatewayFluentImpl.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new GatewayFluentImpl.MetadataNestedImpl(item);
  }
  public GatewayFluentImpl.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public GatewayFluentImpl.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public GatewayFluentImpl.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public GatewaySpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public GatewaySpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(GatewaySpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new GatewaySpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public GatewayFluentImpl.SpecNested<A> withNewSpec() {
    return new GatewayFluentImpl.SpecNestedImpl();
  }
  public GatewayFluentImpl.SpecNested<A> withNewSpecLike(GatewaySpec item) {
    return new GatewayFluentImpl.SpecNestedImpl(item);
  }
  public GatewayFluentImpl.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public GatewayFluentImpl.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new GatewaySpecBuilder().build());
  }
  public GatewayFluentImpl.SpecNested<A> editOrNewSpecLike(GatewaySpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  public IstioStatus getStatus() {
    return this.status;
  }
  public A withStatus(IstioStatus status) {
    this.status=status; return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    GatewayFluentImpl that = (GatewayFluentImpl) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(metadata, that.metadata)) return false;

    if (!java.util.Objects.equals(spec, that.spec)) return false;

    if (!java.util.Objects.equals(status, that.status)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<GatewayFluentImpl.MetadataNested<N>> implements GatewayFluentImpl.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) GatewayFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends GatewaySpecFluentImpl<GatewayFluentImpl.SpecNested<N>> implements GatewayFluentImpl.SpecNested<N>,Nested<N>{
    SpecNestedImpl(GatewaySpec item) {
      this.builder = new GatewaySpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new GatewaySpecBuilder(this);
    }
    GatewaySpecBuilder builder;
    public N and() {
      return (N) GatewayFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  
}