package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.istio.api.meta.v1alpha1.IstioStatus;
import java.lang.Object;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PeerAuthenticationFluentImpl<A extends PeerAuthenticationFluent<A>> extends BaseFluent<A> implements PeerAuthenticationFluent<A>{
  public PeerAuthenticationFluentImpl() {
  }
  public PeerAuthenticationFluentImpl(PeerAuthentication instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private PeerAuthenticationSpecBuilder spec;
  private IstioStatus status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public PeerAuthenticationFluent.MetadataNested<A> withNewMetadata() {
    return new PeerAuthenticationFluentImpl.MetadataNestedImpl();
  }
  public PeerAuthenticationFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new PeerAuthenticationFluentImpl.MetadataNestedImpl(item);
  }
  public PeerAuthenticationFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public PeerAuthenticationFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public PeerAuthenticationFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public PeerAuthenticationSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public PeerAuthenticationSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(PeerAuthenticationSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new PeerAuthenticationSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public PeerAuthenticationFluent.SpecNested<A> withNewSpec() {
    return new PeerAuthenticationFluentImpl.SpecNestedImpl();
  }
  public PeerAuthenticationFluent.SpecNested<A> withNewSpecLike(PeerAuthenticationSpec item) {
    return new PeerAuthenticationFluentImpl.SpecNestedImpl(item);
  }
  public PeerAuthenticationFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public PeerAuthenticationFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new PeerAuthenticationSpecBuilder().build());
  }
  public PeerAuthenticationFluent.SpecNested<A> editOrNewSpecLike(PeerAuthenticationSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  public IstioStatus getStatus() {
    return this.status;
  }
  public A withStatus(IstioStatus status) {
    this.status=status; return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PeerAuthenticationFluentImpl that = (PeerAuthenticationFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<PeerAuthenticationFluent.MetadataNested<N>> implements PeerAuthenticationFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) PeerAuthenticationFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends PeerAuthenticationSpecFluentImpl<PeerAuthenticationFluent.SpecNested<N>> implements PeerAuthenticationFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(PeerAuthenticationSpec item) {
      this.builder = new PeerAuthenticationSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new PeerAuthenticationSpecBuilder(this);
    }
    PeerAuthenticationSpecBuilder builder;
    public N and() {
      return (N) PeerAuthenticationFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  
}