package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LoadBalancerSettingsSimpleBuilder extends LoadBalancerSettingsSimpleFluentImpl<LoadBalancerSettingsSimpleBuilder> implements VisitableBuilder<LoadBalancerSettingsSimple,LoadBalancerSettingsSimpleBuilder>{
  public LoadBalancerSettingsSimpleBuilder() {
    this(false);
  }
  public LoadBalancerSettingsSimpleBuilder(Boolean validationEnabled) {
    this(new LoadBalancerSettingsSimple(), validationEnabled);
  }
  public LoadBalancerSettingsSimpleBuilder(LoadBalancerSettingsSimpleFluent<?> fluent) {
    this(fluent, false);
  }
  public LoadBalancerSettingsSimpleBuilder(LoadBalancerSettingsSimpleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LoadBalancerSettingsSimple(), validationEnabled);
  }
  public LoadBalancerSettingsSimpleBuilder(LoadBalancerSettingsSimpleFluent<?> fluent,LoadBalancerSettingsSimple instance) {
    this(fluent, instance, false);
  }
  public LoadBalancerSettingsSimpleBuilder(LoadBalancerSettingsSimpleFluent<?> fluent,LoadBalancerSettingsSimple instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withSimple(instance.getSimple()); 
    this.validationEnabled = validationEnabled; 
  }
  public LoadBalancerSettingsSimpleBuilder(LoadBalancerSettingsSimple instance) {
    this(instance,false);
  }
  public LoadBalancerSettingsSimpleBuilder(LoadBalancerSettingsSimple instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withSimple(instance.getSimple()); 
    this.validationEnabled = validationEnabled; 
  }
  LoadBalancerSettingsSimpleFluent<?> fluent;
  Boolean validationEnabled;
  public LoadBalancerSettingsSimple build() {
    LoadBalancerSettingsSimple buildable = new LoadBalancerSettingsSimple(fluent.getSimple());
    return buildable;
  }
  
}