package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RuleFromBuilder extends RuleFromFluentImpl<RuleFromBuilder> implements VisitableBuilder<RuleFrom,RuleFromBuilder>{
  public RuleFromBuilder() {
    this(false);
  }
  public RuleFromBuilder(Boolean validationEnabled) {
    this(new RuleFrom(), validationEnabled);
  }
  public RuleFromBuilder(RuleFromFluent<?> fluent) {
    this(fluent, false);
  }
  public RuleFromBuilder(RuleFromFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RuleFrom(), validationEnabled);
  }
  public RuleFromBuilder(RuleFromFluent<?> fluent,RuleFrom instance) {
    this(fluent, instance, false);
  }
  public RuleFromBuilder(RuleFromFluent<?> fluent,RuleFrom instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withSource(instance.getSource()); 
    this.validationEnabled = validationEnabled; 
  }
  public RuleFromBuilder(RuleFrom instance) {
    this(instance,false);
  }
  public RuleFromBuilder(RuleFrom instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withSource(instance.getSource()); 
    this.validationEnabled = validationEnabled; 
  }
  RuleFromFluent<?> fluent;
  Boolean validationEnabled;
  public RuleFrom build() {
    RuleFrom buildable = new RuleFrom(fluent.getSource());
    return buildable;
  }
  
}