package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import java.util.Collection;

 /**
  * Generated
  */
public interface ServiceEntrySpecFluent<A extends ServiceEntrySpecFluent<A>> extends Fluent<A>{
  public A addToAddresses(Integer index,String item);
  public A setToAddresses(Integer index,String item);
  public A addToAddresses(java.lang.String... items);
  public A addAllToAddresses(Collection<String> items);
  public A removeFromAddresses(java.lang.String... items);
  public A removeAllFromAddresses(Collection<String> items);
  public List<String> getAddresses();
  public String getAddress(Integer index);
  public String getFirstAddress();
  public String getLastAddress();
  public String getMatchingAddress(Predicate<String> predicate);
  public Boolean hasMatchingAddress(Predicate<String> predicate);
  public A withAddresses(List<String> addresses);
  public A withAddresses(java.lang.String... addresses);
  public Boolean hasAddresses();
  public A addToEndpoints(Integer index,WorkloadEntrySpec item);
  public A setToEndpoints(Integer index,WorkloadEntrySpec item);
  public A addToEndpoints(io.fabric8.istio.api.networking.v1beta1.WorkloadEntrySpec... items);
  public A addAllToEndpoints(Collection<WorkloadEntrySpec> items);
  public A removeFromEndpoints(io.fabric8.istio.api.networking.v1beta1.WorkloadEntrySpec... items);
  public A removeAllFromEndpoints(Collection<WorkloadEntrySpec> items);
  public A removeMatchingFromEndpoints(Predicate<WorkloadEntrySpecBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildEndpoints instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<WorkloadEntrySpec> getEndpoints();
  public List<WorkloadEntrySpec> buildEndpoints();
  public WorkloadEntrySpec buildEndpoint(Integer index);
  public WorkloadEntrySpec buildFirstEndpoint();
  public WorkloadEntrySpec buildLastEndpoint();
  public WorkloadEntrySpec buildMatchingEndpoint(Predicate<WorkloadEntrySpecBuilder> predicate);
  public Boolean hasMatchingEndpoint(Predicate<WorkloadEntrySpecBuilder> predicate);
  public A withEndpoints(List<WorkloadEntrySpec> endpoints);
  public A withEndpoints(io.fabric8.istio.api.networking.v1beta1.WorkloadEntrySpec... endpoints);
  public Boolean hasEndpoints();
  public ServiceEntrySpecFluent.EndpointsNested<A> addNewEndpoint();
  public ServiceEntrySpecFluent.EndpointsNested<A> addNewEndpointLike(WorkloadEntrySpec item);
  public ServiceEntrySpecFluent.EndpointsNested<A> setNewEndpointLike(Integer index,WorkloadEntrySpec item);
  public ServiceEntrySpecFluent.EndpointsNested<A> editEndpoint(Integer index);
  public ServiceEntrySpecFluent.EndpointsNested<A> editFirstEndpoint();
  public ServiceEntrySpecFluent.EndpointsNested<A> editLastEndpoint();
  public ServiceEntrySpecFluent.EndpointsNested<A> editMatchingEndpoint(Predicate<WorkloadEntrySpecBuilder> predicate);
  public A addToExportTo(Integer index,String item);
  public A setToExportTo(Integer index,String item);
  public A addToExportTo(java.lang.String... items);
  public A addAllToExportTo(Collection<String> items);
  public A removeFromExportTo(java.lang.String... items);
  public A removeAllFromExportTo(Collection<String> items);
  public List<String> getExportTo();
  public String getExportTo(Integer index);
  public String getFirstExportTo();
  public String getLastExportTo();
  public String getMatchingExportTo(Predicate<String> predicate);
  public Boolean hasMatchingExportTo(Predicate<String> predicate);
  public A withExportTo(List<String> exportTo);
  public A withExportTo(java.lang.String... exportTo);
  public Boolean hasExportTo();
  public A addToHosts(Integer index,String item);
  public A setToHosts(Integer index,String item);
  public A addToHosts(java.lang.String... items);
  public A addAllToHosts(Collection<String> items);
  public A removeFromHosts(java.lang.String... items);
  public A removeAllFromHosts(Collection<String> items);
  public List<String> getHosts();
  public String getHost(Integer index);
  public String getFirstHost();
  public String getLastHost();
  public String getMatchingHost(Predicate<String> predicate);
  public Boolean hasMatchingHost(Predicate<String> predicate);
  public A withHosts(List<String> hosts);
  public A withHosts(java.lang.String... hosts);
  public Boolean hasHosts();
  public ServiceEntryLocation getLocation();
  public A withLocation(ServiceEntryLocation location);
  public Boolean hasLocation();
  public A addToPorts(Integer index,Port item);
  public A setToPorts(Integer index,Port item);
  public A addToPorts(io.fabric8.istio.api.networking.v1beta1.Port... items);
  public A addAllToPorts(Collection<Port> items);
  public A removeFromPorts(io.fabric8.istio.api.networking.v1beta1.Port... items);
  public A removeAllFromPorts(Collection<Port> items);
  public A removeMatchingFromPorts(Predicate<PortBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildPorts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Port> getPorts();
  public List<Port> buildPorts();
  public Port buildPort(Integer index);
  public Port buildFirstPort();
  public Port buildLastPort();
  public Port buildMatchingPort(Predicate<PortBuilder> predicate);
  public Boolean hasMatchingPort(Predicate<PortBuilder> predicate);
  public A withPorts(List<Port> ports);
  public A withPorts(io.fabric8.istio.api.networking.v1beta1.Port... ports);
  public Boolean hasPorts();
  public A addNewPort(String name,Integer number,String protocol,Integer targetPort);
  public ServiceEntrySpecFluent.PortsNested<A> addNewPort();
  public ServiceEntrySpecFluent.PortsNested<A> addNewPortLike(Port item);
  public ServiceEntrySpecFluent.PortsNested<A> setNewPortLike(Integer index,Port item);
  public ServiceEntrySpecFluent.PortsNested<A> editPort(Integer index);
  public ServiceEntrySpecFluent.PortsNested<A> editFirstPort();
  public ServiceEntrySpecFluent.PortsNested<A> editLastPort();
  public ServiceEntrySpecFluent.PortsNested<A> editMatchingPort(Predicate<PortBuilder> predicate);
  public ServiceEntryResolution getResolution();
  public A withResolution(ServiceEntryResolution resolution);
  public Boolean hasResolution();
  public A addToSubjectAltNames(Integer index,String item);
  public A setToSubjectAltNames(Integer index,String item);
  public A addToSubjectAltNames(java.lang.String... items);
  public A addAllToSubjectAltNames(Collection<String> items);
  public A removeFromSubjectAltNames(java.lang.String... items);
  public A removeAllFromSubjectAltNames(Collection<String> items);
  public List<String> getSubjectAltNames();
  public String getSubjectAltName(Integer index);
  public String getFirstSubjectAltName();
  public String getLastSubjectAltName();
  public String getMatchingSubjectAltName(Predicate<String> predicate);
  public Boolean hasMatchingSubjectAltName(Predicate<String> predicate);
  public A withSubjectAltNames(List<String> subjectAltNames);
  public A withSubjectAltNames(java.lang.String... subjectAltNames);
  public Boolean hasSubjectAltNames();
  
  /**
   * This method has been deprecated, please use method buildWorkloadSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public WorkloadSelector getWorkloadSelector();
  public WorkloadSelector buildWorkloadSelector();
  public A withWorkloadSelector(WorkloadSelector workloadSelector);
  public Boolean hasWorkloadSelector();
  public ServiceEntrySpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelector();
  public ServiceEntrySpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelectorLike(WorkloadSelector item);
  public ServiceEntrySpecFluent.WorkloadSelectorNested<A> editWorkloadSelector();
  public ServiceEntrySpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelector();
  public ServiceEntrySpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelectorLike(WorkloadSelector item);
  public interface EndpointsNested<N> extends Nested<N>,WorkloadEntrySpecFluent<ServiceEntrySpecFluent.EndpointsNested<N>>{
    public N and();
    public N endEndpoint();
    
  }
  public interface PortsNested<N> extends Nested<N>,PortFluent<ServiceEntrySpecFluent.PortsNested<N>>{
    public N and();
    public N endPort();
    
  }
  public interface WorkloadSelectorNested<N> extends Nested<N>,WorkloadSelectorFluent<ServiceEntrySpecFluent.WorkloadSelectorNested<N>>{
    public N and();
    public N endWorkloadSelector();
    
  }
  
}