package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPFaultInjectionBuilder extends HTTPFaultInjectionFluentImpl<HTTPFaultInjectionBuilder> implements VisitableBuilder<HTTPFaultInjection,HTTPFaultInjectionBuilder>{
  public HTTPFaultInjectionBuilder() {
    this(false);
  }
  public HTTPFaultInjectionBuilder(Boolean validationEnabled) {
    this(new HTTPFaultInjection(), validationEnabled);
  }
  public HTTPFaultInjectionBuilder(HTTPFaultInjectionFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPFaultInjectionBuilder(HTTPFaultInjectionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPFaultInjection(), validationEnabled);
  }
  public HTTPFaultInjectionBuilder(HTTPFaultInjectionFluent<?> fluent,HTTPFaultInjection instance) {
    this(fluent, instance, false);
  }
  public HTTPFaultInjectionBuilder(HTTPFaultInjectionFluent<?> fluent,HTTPFaultInjection instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAbort(instance.getAbort()); 
    fluent.withDelay(instance.getDelay()); 
    this.validationEnabled = validationEnabled; 
  }
  public HTTPFaultInjectionBuilder(HTTPFaultInjection instance) {
    this(instance,false);
  }
  public HTTPFaultInjectionBuilder(HTTPFaultInjection instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAbort(instance.getAbort()); 
    this.withDelay(instance.getDelay()); 
    this.validationEnabled = validationEnabled; 
  }
  HTTPFaultInjectionFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPFaultInjection build() {
    HTTPFaultInjection buildable = new HTTPFaultInjection(fluent.getAbort(),fluent.getDelay());
    return buildable;
  }
  
}