package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class WorkloadSelectorBuilder extends WorkloadSelectorFluentImpl<WorkloadSelectorBuilder> implements VisitableBuilder<WorkloadSelector,WorkloadSelectorBuilder>{
  public WorkloadSelectorBuilder() {
    this(false);
  }
  public WorkloadSelectorBuilder(Boolean validationEnabled) {
    this(new WorkloadSelector(), validationEnabled);
  }
  public WorkloadSelectorBuilder(WorkloadSelectorFluent<?> fluent) {
    this(fluent, false);
  }
  public WorkloadSelectorBuilder(WorkloadSelectorFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new WorkloadSelector(), validationEnabled);
  }
  public WorkloadSelectorBuilder(WorkloadSelectorFluent<?> fluent,WorkloadSelector instance) {
    this(fluent, instance, false);
  }
  public WorkloadSelectorBuilder(WorkloadSelectorFluent<?> fluent,WorkloadSelector instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLabels(instance.getLabels()); 
    this.validationEnabled = validationEnabled; 
  }
  public WorkloadSelectorBuilder(WorkloadSelector instance) {
    this(instance,false);
  }
  public WorkloadSelectorBuilder(WorkloadSelector instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withLabels(instance.getLabels()); 
    this.validationEnabled = validationEnabled; 
  }
  WorkloadSelectorFluent<?> fluent;
  Boolean validationEnabled;
  public WorkloadSelector build() {
    WorkloadSelector buildable = new WorkloadSelector(fluent.getLabels());
    return buildable;
  }
  
}