package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TLSRouteBuilder extends TLSRouteFluentImpl<TLSRouteBuilder> implements VisitableBuilder<TLSRoute,TLSRouteBuilder>{
  public TLSRouteBuilder() {
    this(false);
  }
  public TLSRouteBuilder(Boolean validationEnabled) {
    this(new TLSRoute(), validationEnabled);
  }
  public TLSRouteBuilder(TLSRouteFluent<?> fluent) {
    this(fluent, false);
  }
  public TLSRouteBuilder(TLSRouteFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TLSRoute(), validationEnabled);
  }
  public TLSRouteBuilder(TLSRouteFluent<?> fluent,TLSRoute instance) {
    this(fluent, instance, false);
  }
  public TLSRouteBuilder(TLSRouteFluent<?> fluent,TLSRoute instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMatch(instance.getMatch()); 
    fluent.withRoute(instance.getRoute()); 
    this.validationEnabled = validationEnabled; 
  }
  public TLSRouteBuilder(TLSRoute instance) {
    this(instance,false);
  }
  public TLSRouteBuilder(TLSRoute instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMatch(instance.getMatch()); 
    this.withRoute(instance.getRoute()); 
    this.validationEnabled = validationEnabled; 
  }
  TLSRouteFluent<?> fluent;
  Boolean validationEnabled;
  public TLSRoute build() {
    TLSRoute buildable = new TLSRoute(fluent.getMatch(),fluent.getRoute());
    return buildable;
  }
  
}