package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ServiceEntrySpecFluentImpl<A extends ServiceEntrySpecFluent<A>> extends BaseFluent<A> implements ServiceEntrySpecFluent<A>{
  public ServiceEntrySpecFluentImpl() {
  }
  public ServiceEntrySpecFluentImpl(ServiceEntrySpec instance) {
    this.withAddresses(instance.getAddresses()); 
    this.withEndpoints(instance.getEndpoints()); 
    this.withExportTo(instance.getExportTo()); 
    this.withHosts(instance.getHosts()); 
    this.withLocation(instance.getLocation()); 
    this.withPorts(instance.getPorts()); 
    this.withResolution(instance.getResolution()); 
    this.withSubjectAltNames(instance.getSubjectAltNames()); 
    this.withWorkloadSelector(instance.getWorkloadSelector()); 
  }
  private List<String> addresses = new ArrayList<String>();
  private ArrayList<WorkloadEntrySpecBuilder> endpoints = new ArrayList<WorkloadEntrySpecBuilder>();
  private List<String> exportTo = new ArrayList<String>();
  private List<String> hosts = new ArrayList<String>();
  private ServiceEntryLocation location;
  private ArrayList<PortBuilder> ports = new ArrayList<PortBuilder>();
  private ServiceEntryResolution resolution;
  private List<String> subjectAltNames = new ArrayList<String>();
  private WorkloadSelectorBuilder workloadSelector;
  public A addToAddresses(Integer index,String item) {
    if (this.addresses == null) {this.addresses = new ArrayList<String>();}
    this.addresses.add(index, item);
    return (A)this;
  }
  public A setToAddresses(Integer index,String item) {
    if (this.addresses == null) {this.addresses = new ArrayList<String>();}
    this.addresses.set(index, item); return (A)this;
  }
  public A addToAddresses(java.lang.String... items) {
    if (this.addresses == null) {this.addresses = new ArrayList<String>();}
    for (String item : items) {this.addresses.add(item);} return (A)this;
  }
  public A addAllToAddresses(Collection<String> items) {
    if (this.addresses == null) {this.addresses = new ArrayList<String>();}
    for (String item : items) {this.addresses.add(item);} return (A)this;
  }
  public A removeFromAddresses(java.lang.String... items) {
    for (String item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
  }
  public A removeAllFromAddresses(Collection<String> items) {
    for (String item : items) {if (this.addresses!= null){ this.addresses.remove(item);}} return (A)this;
  }
  public List<String> getAddresses() {
    return this.addresses;
  }
  public String getAddress(Integer index) {
    return this.addresses.get(index);
  }
  public String getFirstAddress() {
    return this.addresses.get(0);
  }
  public String getLastAddress() {
    return this.addresses.get(addresses.size() - 1);
  }
  public String getMatchingAddress(Predicate<String> predicate) {
    for (String item: addresses) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingAddress(Predicate<String> predicate) {
    for (String item: addresses) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAddresses(List<String> addresses) {
    if (addresses != null) {this.addresses = new ArrayList(); for (String item : addresses){this.addToAddresses(item);}} else { this.addresses = null;} return (A) this;
  }
  public A withAddresses(java.lang.String... addresses) {
    if (this.addresses != null) {this.addresses.clear();}
    if (addresses != null) {for (String item :addresses){ this.addToAddresses(item);}} return (A) this;
  }
  public Boolean hasAddresses() {
    return addresses != null && !addresses.isEmpty();
  }
  public A addToEndpoints(Integer index,WorkloadEntrySpec item) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();}
    WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").add(index >= 0 ? index : _visitables.get("endpoints").size(), builder);this.endpoints.add(index >= 0 ? index : endpoints.size(), builder); return (A)this;
  }
  public A setToEndpoints(Integer index,WorkloadEntrySpec item) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();}
    WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);
    if (index < 0 || index >= _visitables.get("endpoints").size()) { _visitables.get("endpoints").add(builder); } else { _visitables.get("endpoints").set(index, builder);}
    if (index < 0 || index >= endpoints.size()) { endpoints.add(builder); } else { endpoints.set(index, builder);}
     return (A)this;
  }
  public A addToEndpoints(io.fabric8.istio.api.networking.v1beta1.WorkloadEntrySpec... items) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();}
    for (WorkloadEntrySpec item : items) {WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  public A addAllToEndpoints(Collection<WorkloadEntrySpec> items) {
    if (this.endpoints == null) {this.endpoints = new ArrayList<WorkloadEntrySpecBuilder>();}
    for (WorkloadEntrySpec item : items) {WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").add(builder);this.endpoints.add(builder);} return (A)this;
  }
  public A removeFromEndpoints(io.fabric8.istio.api.networking.v1beta1.WorkloadEntrySpec... items) {
    for (WorkloadEntrySpec item : items) {WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
  }
  public A removeAllFromEndpoints(Collection<WorkloadEntrySpec> items) {
    for (WorkloadEntrySpec item : items) {WorkloadEntrySpecBuilder builder = new WorkloadEntrySpecBuilder(item);_visitables.get("endpoints").remove(builder);if (this.endpoints != null) {this.endpoints.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromEndpoints(Predicate<WorkloadEntrySpecBuilder> predicate) {
    if (endpoints == null) return (A) this;
    final Iterator<WorkloadEntrySpecBuilder> each = endpoints.iterator();
    final List visitables = _visitables.get("endpoints");
    while (each.hasNext()) {
      WorkloadEntrySpecBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildEndpoints instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<WorkloadEntrySpec> getEndpoints() {
    return endpoints != null ? build(endpoints) : null;
  }
  public List<WorkloadEntrySpec> buildEndpoints() {
    return endpoints != null ? build(endpoints) : null;
  }
  public WorkloadEntrySpec buildEndpoint(Integer index) {
    return this.endpoints.get(index).build();
  }
  public WorkloadEntrySpec buildFirstEndpoint() {
    return this.endpoints.get(0).build();
  }
  public WorkloadEntrySpec buildLastEndpoint() {
    return this.endpoints.get(endpoints.size() - 1).build();
  }
  public WorkloadEntrySpec buildMatchingEndpoint(Predicate<WorkloadEntrySpecBuilder> predicate) {
    for (WorkloadEntrySpecBuilder item: endpoints) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingEndpoint(Predicate<WorkloadEntrySpecBuilder> predicate) {
    for (WorkloadEntrySpecBuilder item: endpoints) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withEndpoints(List<WorkloadEntrySpec> endpoints) {
    if (this.endpoints != null) { _visitables.get("endpoints").removeAll(this.endpoints);}
    if (endpoints != null) {this.endpoints = new ArrayList(); for (WorkloadEntrySpec item : endpoints){this.addToEndpoints(item);}} else { this.endpoints = null;} return (A) this;
  }
  public A withEndpoints(io.fabric8.istio.api.networking.v1beta1.WorkloadEntrySpec... endpoints) {
    if (this.endpoints != null) {this.endpoints.clear();}
    if (endpoints != null) {for (WorkloadEntrySpec item :endpoints){ this.addToEndpoints(item);}} return (A) this;
  }
  public Boolean hasEndpoints() {
    return endpoints != null && !endpoints.isEmpty();
  }
  public ServiceEntrySpecFluent.EndpointsNested<A> addNewEndpoint() {
    return new ServiceEntrySpecFluentImpl.EndpointsNestedImpl();
  }
  public ServiceEntrySpecFluent.EndpointsNested<A> addNewEndpointLike(WorkloadEntrySpec item) {
    return new ServiceEntrySpecFluentImpl.EndpointsNestedImpl(-1, item);
  }
  public ServiceEntrySpecFluent.EndpointsNested<A> setNewEndpointLike(Integer index,WorkloadEntrySpec item) {
    return new ServiceEntrySpecFluentImpl.EndpointsNestedImpl(index, item);
  }
  public ServiceEntrySpecFluent.EndpointsNested<A> editEndpoint(Integer index) {
    if (endpoints.size() <= index) throw new RuntimeException("Can't edit endpoints. Index exceeds size.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public ServiceEntrySpecFluent.EndpointsNested<A> editFirstEndpoint() {
    if (endpoints.size() == 0) throw new RuntimeException("Can't edit first endpoints. The list is empty.");
    return setNewEndpointLike(0, buildEndpoint(0));
  }
  public ServiceEntrySpecFluent.EndpointsNested<A> editLastEndpoint() {
    int index = endpoints.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last endpoints. The list is empty.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public ServiceEntrySpecFluent.EndpointsNested<A> editMatchingEndpoint(Predicate<WorkloadEntrySpecBuilder> predicate) {
    int index = -1;
    for (int i=0;i<endpoints.size();i++) { 
    if (predicate.test(endpoints.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching endpoints. No match found.");
    return setNewEndpointLike(index, buildEndpoint(index));
  }
  public A addToExportTo(Integer index,String item) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    this.exportTo.add(index, item);
    return (A)this;
  }
  public A setToExportTo(Integer index,String item) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    this.exportTo.set(index, item); return (A)this;
  }
  public A addToExportTo(java.lang.String... items) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    for (String item : items) {this.exportTo.add(item);} return (A)this;
  }
  public A addAllToExportTo(Collection<String> items) {
    if (this.exportTo == null) {this.exportTo = new ArrayList<String>();}
    for (String item : items) {this.exportTo.add(item);} return (A)this;
  }
  public A removeFromExportTo(java.lang.String... items) {
    for (String item : items) {if (this.exportTo!= null){ this.exportTo.remove(item);}} return (A)this;
  }
  public A removeAllFromExportTo(Collection<String> items) {
    for (String item : items) {if (this.exportTo!= null){ this.exportTo.remove(item);}} return (A)this;
  }
  public List<String> getExportTo() {
    return this.exportTo;
  }
  public String getExportTo(Integer index) {
    return this.exportTo.get(index);
  }
  public String getFirstExportTo() {
    return this.exportTo.get(0);
  }
  public String getLastExportTo() {
    return this.exportTo.get(exportTo.size() - 1);
  }
  public String getMatchingExportTo(Predicate<String> predicate) {
    for (String item: exportTo) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingExportTo(Predicate<String> predicate) {
    for (String item: exportTo) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExportTo(List<String> exportTo) {
    if (exportTo != null) {this.exportTo = new ArrayList(); for (String item : exportTo){this.addToExportTo(item);}} else { this.exportTo = null;} return (A) this;
  }
  public A withExportTo(java.lang.String... exportTo) {
    if (this.exportTo != null) {this.exportTo.clear();}
    if (exportTo != null) {for (String item :exportTo){ this.addToExportTo(item);}} return (A) this;
  }
  public Boolean hasExportTo() {
    return exportTo != null && !exportTo.isEmpty();
  }
  public A addToHosts(Integer index,String item) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    this.hosts.add(index, item);
    return (A)this;
  }
  public A setToHosts(Integer index,String item) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    this.hosts.set(index, item); return (A)this;
  }
  public A addToHosts(java.lang.String... items) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    for (String item : items) {this.hosts.add(item);} return (A)this;
  }
  public A addAllToHosts(Collection<String> items) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    for (String item : items) {this.hosts.add(item);} return (A)this;
  }
  public A removeFromHosts(java.lang.String... items) {
    for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
  }
  public A removeAllFromHosts(Collection<String> items) {
    for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
  }
  public List<String> getHosts() {
    return this.hosts;
  }
  public String getHost(Integer index) {
    return this.hosts.get(index);
  }
  public String getFirstHost() {
    return this.hosts.get(0);
  }
  public String getLastHost() {
    return this.hosts.get(hosts.size() - 1);
  }
  public String getMatchingHost(Predicate<String> predicate) {
    for (String item: hosts) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingHost(Predicate<String> predicate) {
    for (String item: hosts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHosts(List<String> hosts) {
    if (hosts != null) {this.hosts = new ArrayList(); for (String item : hosts){this.addToHosts(item);}} else { this.hosts = null;} return (A) this;
  }
  public A withHosts(java.lang.String... hosts) {
    if (this.hosts != null) {this.hosts.clear();}
    if (hosts != null) {for (String item :hosts){ this.addToHosts(item);}} return (A) this;
  }
  public Boolean hasHosts() {
    return hosts != null && !hosts.isEmpty();
  }
  public ServiceEntryLocation getLocation() {
    return this.location;
  }
  public A withLocation(ServiceEntryLocation location) {
    this.location=location; return (A) this;
  }
  public Boolean hasLocation() {
    return this.location != null;
  }
  public A addToPorts(Integer index,Port item) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    PortBuilder builder = new PortBuilder(item);_visitables.get("ports").add(index >= 0 ? index : _visitables.get("ports").size(), builder);this.ports.add(index >= 0 ? index : ports.size(), builder); return (A)this;
  }
  public A setToPorts(Integer index,Port item) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    PortBuilder builder = new PortBuilder(item);
    if (index < 0 || index >= _visitables.get("ports").size()) { _visitables.get("ports").add(builder); } else { _visitables.get("ports").set(index, builder);}
    if (index < 0 || index >= ports.size()) { ports.add(builder); } else { ports.set(index, builder);}
     return (A)this;
  }
  public A addToPorts(io.fabric8.istio.api.networking.v1beta1.Port... items) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A addAllToPorts(Collection<Port> items) {
    if (this.ports == null) {this.ports = new ArrayList<PortBuilder>();}
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").add(builder);this.ports.add(builder);} return (A)this;
  }
  public A removeFromPorts(io.fabric8.istio.api.networking.v1beta1.Port... items) {
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeAllFromPorts(Collection<Port> items) {
    for (Port item : items) {PortBuilder builder = new PortBuilder(item);_visitables.get("ports").remove(builder);if (this.ports != null) {this.ports.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPorts(Predicate<PortBuilder> predicate) {
    if (ports == null) return (A) this;
    final Iterator<PortBuilder> each = ports.iterator();
    final List visitables = _visitables.get("ports");
    while (each.hasNext()) {
      PortBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPorts instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Port> getPorts() {
    return ports != null ? build(ports) : null;
  }
  public List<Port> buildPorts() {
    return ports != null ? build(ports) : null;
  }
  public Port buildPort(Integer index) {
    return this.ports.get(index).build();
  }
  public Port buildFirstPort() {
    return this.ports.get(0).build();
  }
  public Port buildLastPort() {
    return this.ports.get(ports.size() - 1).build();
  }
  public Port buildMatchingPort(Predicate<PortBuilder> predicate) {
    for (PortBuilder item: ports) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPort(Predicate<PortBuilder> predicate) {
    for (PortBuilder item: ports) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPorts(List<Port> ports) {
    if (this.ports != null) { _visitables.get("ports").removeAll(this.ports);}
    if (ports != null) {this.ports = new ArrayList(); for (Port item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
  }
  public A withPorts(io.fabric8.istio.api.networking.v1beta1.Port... ports) {
    if (this.ports != null) {this.ports.clear();}
    if (ports != null) {for (Port item :ports){ this.addToPorts(item);}} return (A) this;
  }
  public Boolean hasPorts() {
    return ports != null && !ports.isEmpty();
  }
  public A addNewPort(String name,Integer number,String protocol,Integer targetPort) {
    return (A)addToPorts(new Port(name, number, protocol, targetPort));
  }
  public ServiceEntrySpecFluent.PortsNested<A> addNewPort() {
    return new ServiceEntrySpecFluentImpl.PortsNestedImpl();
  }
  public ServiceEntrySpecFluent.PortsNested<A> addNewPortLike(Port item) {
    return new ServiceEntrySpecFluentImpl.PortsNestedImpl(-1, item);
  }
  public ServiceEntrySpecFluent.PortsNested<A> setNewPortLike(Integer index,Port item) {
    return new ServiceEntrySpecFluentImpl.PortsNestedImpl(index, item);
  }
  public ServiceEntrySpecFluent.PortsNested<A> editPort(Integer index) {
    if (ports.size() <= index) throw new RuntimeException("Can't edit ports. Index exceeds size.");
    return setNewPortLike(index, buildPort(index));
  }
  public ServiceEntrySpecFluent.PortsNested<A> editFirstPort() {
    if (ports.size() == 0) throw new RuntimeException("Can't edit first ports. The list is empty.");
    return setNewPortLike(0, buildPort(0));
  }
  public ServiceEntrySpecFluent.PortsNested<A> editLastPort() {
    int index = ports.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ports. The list is empty.");
    return setNewPortLike(index, buildPort(index));
  }
  public ServiceEntrySpecFluent.PortsNested<A> editMatchingPort(Predicate<PortBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ports.size();i++) { 
    if (predicate.test(ports.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ports. No match found.");
    return setNewPortLike(index, buildPort(index));
  }
  public ServiceEntryResolution getResolution() {
    return this.resolution;
  }
  public A withResolution(ServiceEntryResolution resolution) {
    this.resolution=resolution; return (A) this;
  }
  public Boolean hasResolution() {
    return this.resolution != null;
  }
  public A addToSubjectAltNames(Integer index,String item) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
    this.subjectAltNames.add(index, item);
    return (A)this;
  }
  public A setToSubjectAltNames(Integer index,String item) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
    this.subjectAltNames.set(index, item); return (A)this;
  }
  public A addToSubjectAltNames(java.lang.String... items) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
    for (String item : items) {this.subjectAltNames.add(item);} return (A)this;
  }
  public A addAllToSubjectAltNames(Collection<String> items) {
    if (this.subjectAltNames == null) {this.subjectAltNames = new ArrayList<String>();}
    for (String item : items) {this.subjectAltNames.add(item);} return (A)this;
  }
  public A removeFromSubjectAltNames(java.lang.String... items) {
    for (String item : items) {if (this.subjectAltNames!= null){ this.subjectAltNames.remove(item);}} return (A)this;
  }
  public A removeAllFromSubjectAltNames(Collection<String> items) {
    for (String item : items) {if (this.subjectAltNames!= null){ this.subjectAltNames.remove(item);}} return (A)this;
  }
  public List<String> getSubjectAltNames() {
    return this.subjectAltNames;
  }
  public String getSubjectAltName(Integer index) {
    return this.subjectAltNames.get(index);
  }
  public String getFirstSubjectAltName() {
    return this.subjectAltNames.get(0);
  }
  public String getLastSubjectAltName() {
    return this.subjectAltNames.get(subjectAltNames.size() - 1);
  }
  public String getMatchingSubjectAltName(Predicate<String> predicate) {
    for (String item: subjectAltNames) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingSubjectAltName(Predicate<String> predicate) {
    for (String item: subjectAltNames) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withSubjectAltNames(List<String> subjectAltNames) {
    if (subjectAltNames != null) {this.subjectAltNames = new ArrayList(); for (String item : subjectAltNames){this.addToSubjectAltNames(item);}} else { this.subjectAltNames = null;} return (A) this;
  }
  public A withSubjectAltNames(java.lang.String... subjectAltNames) {
    if (this.subjectAltNames != null) {this.subjectAltNames.clear();}
    if (subjectAltNames != null) {for (String item :subjectAltNames){ this.addToSubjectAltNames(item);}} return (A) this;
  }
  public Boolean hasSubjectAltNames() {
    return subjectAltNames != null && !subjectAltNames.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildWorkloadSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public WorkloadSelector getWorkloadSelector() {
    return this.workloadSelector!=null ?this.workloadSelector.build():null;
  }
  public WorkloadSelector buildWorkloadSelector() {
    return this.workloadSelector!=null ?this.workloadSelector.build():null;
  }
  public A withWorkloadSelector(WorkloadSelector workloadSelector) {
    _visitables.get("workloadSelector").remove(this.workloadSelector);
    if (workloadSelector!=null){ this.workloadSelector= new WorkloadSelectorBuilder(workloadSelector); _visitables.get("workloadSelector").add(this.workloadSelector);} else { this.workloadSelector = null; _visitables.get("workloadSelector").remove(this.workloadSelector); } return (A) this;
  }
  public Boolean hasWorkloadSelector() {
    return this.workloadSelector != null;
  }
  public ServiceEntrySpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelector() {
    return new ServiceEntrySpecFluentImpl.WorkloadSelectorNestedImpl();
  }
  public ServiceEntrySpecFluent.WorkloadSelectorNested<A> withNewWorkloadSelectorLike(WorkloadSelector item) {
    return new ServiceEntrySpecFluentImpl.WorkloadSelectorNestedImpl(item);
  }
  public ServiceEntrySpecFluent.WorkloadSelectorNested<A> editWorkloadSelector() {
    return withNewWorkloadSelectorLike(getWorkloadSelector());
  }
  public ServiceEntrySpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelector() {
    return withNewWorkloadSelectorLike(getWorkloadSelector() != null ? getWorkloadSelector(): new WorkloadSelectorBuilder().build());
  }
  public ServiceEntrySpecFluent.WorkloadSelectorNested<A> editOrNewWorkloadSelectorLike(WorkloadSelector item) {
    return withNewWorkloadSelectorLike(getWorkloadSelector() != null ? getWorkloadSelector(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ServiceEntrySpecFluentImpl that = (ServiceEntrySpecFluentImpl) o;
    if (addresses != null ? !addresses.equals(that.addresses) :that.addresses != null) return false;
    if (endpoints != null ? !endpoints.equals(that.endpoints) :that.endpoints != null) return false;
    if (exportTo != null ? !exportTo.equals(that.exportTo) :that.exportTo != null) return false;
    if (hosts != null ? !hosts.equals(that.hosts) :that.hosts != null) return false;
    if (location != null ? !location.equals(that.location) :that.location != null) return false;
    if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
    if (resolution != null ? !resolution.equals(that.resolution) :that.resolution != null) return false;
    if (subjectAltNames != null ? !subjectAltNames.equals(that.subjectAltNames) :that.subjectAltNames != null) return false;
    if (workloadSelector != null ? !workloadSelector.equals(that.workloadSelector) :that.workloadSelector != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(addresses,  endpoints,  exportTo,  hosts,  location,  ports,  resolution,  subjectAltNames,  workloadSelector,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (addresses != null && !addresses.isEmpty()) { sb.append("addresses:"); sb.append(addresses + ","); }
    if (endpoints != null && !endpoints.isEmpty()) { sb.append("endpoints:"); sb.append(endpoints + ","); }
    if (exportTo != null && !exportTo.isEmpty()) { sb.append("exportTo:"); sb.append(exportTo + ","); }
    if (hosts != null && !hosts.isEmpty()) { sb.append("hosts:"); sb.append(hosts + ","); }
    if (location != null) { sb.append("location:"); sb.append(location + ","); }
    if (ports != null && !ports.isEmpty()) { sb.append("ports:"); sb.append(ports + ","); }
    if (resolution != null) { sb.append("resolution:"); sb.append(resolution + ","); }
    if (subjectAltNames != null && !subjectAltNames.isEmpty()) { sb.append("subjectAltNames:"); sb.append(subjectAltNames + ","); }
    if (workloadSelector != null) { sb.append("workloadSelector:"); sb.append(workloadSelector); }
    sb.append("}");
    return sb.toString();
  }
  class EndpointsNestedImpl<N> extends WorkloadEntrySpecFluentImpl<ServiceEntrySpecFluent.EndpointsNested<N>> implements ServiceEntrySpecFluent.EndpointsNested<N>,Nested<N>{
    EndpointsNestedImpl(Integer index,WorkloadEntrySpec item) {
      this.index = index;
      this.builder = new WorkloadEntrySpecBuilder(this, item);
    }
    EndpointsNestedImpl() {
      this.index = -1;
      this.builder = new WorkloadEntrySpecBuilder(this);
    }
    WorkloadEntrySpecBuilder builder;
    Integer index;
    public N and() {
      return (N) ServiceEntrySpecFluentImpl.this.setToEndpoints(index,builder.build());
    }
    public N endEndpoint() {
      return and();
    }
    
  }
  class PortsNestedImpl<N> extends PortFluentImpl<ServiceEntrySpecFluent.PortsNested<N>> implements ServiceEntrySpecFluent.PortsNested<N>,Nested<N>{
    PortsNestedImpl(Integer index,Port item) {
      this.index = index;
      this.builder = new PortBuilder(this, item);
    }
    PortsNestedImpl() {
      this.index = -1;
      this.builder = new PortBuilder(this);
    }
    PortBuilder builder;
    Integer index;
    public N and() {
      return (N) ServiceEntrySpecFluentImpl.this.setToPorts(index,builder.build());
    }
    public N endPort() {
      return and();
    }
    
  }
  class WorkloadSelectorNestedImpl<N> extends WorkloadSelectorFluentImpl<ServiceEntrySpecFluent.WorkloadSelectorNested<N>> implements ServiceEntrySpecFluent.WorkloadSelectorNested<N>,Nested<N>{
    WorkloadSelectorNestedImpl(WorkloadSelector item) {
      this.builder = new WorkloadSelectorBuilder(this, item);
    }
    WorkloadSelectorNestedImpl() {
      this.builder = new WorkloadSelectorBuilder(this);
    }
    WorkloadSelectorBuilder builder;
    public N and() {
      return (N) ServiceEntrySpecFluentImpl.this.withWorkloadSelector(builder.build());
    }
    public N endWorkloadSelector() {
      return and();
    }
    
  }
  
}