package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class GatewayBuilder extends GatewayFluentImpl<GatewayBuilder> implements VisitableBuilder<Gateway,GatewayBuilder>{
  public GatewayBuilder() {
    this(false);
  }
  public GatewayBuilder(Boolean validationEnabled) {
    this(new Gateway(), validationEnabled);
  }
  public GatewayBuilder(GatewayFluent<?> fluent) {
    this(fluent, false);
  }
  public GatewayBuilder(GatewayFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Gateway(), validationEnabled);
  }
  public GatewayBuilder(GatewayFluent<?> fluent,Gateway instance) {
    this(fluent, instance, false);
  }
  public GatewayBuilder(GatewayFluent<?> fluent,Gateway instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public GatewayBuilder(Gateway instance) {
    this(instance,false);
  }
  public GatewayBuilder(Gateway instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  GatewayFluent<?> fluent;
  Boolean validationEnabled;
  public Gateway build() {
    Gateway buildable = new Gateway(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}