package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SourceBuilder extends SourceFluentImpl<SourceBuilder> implements VisitableBuilder<Source,SourceBuilder>{
  public SourceBuilder() {
    this(false);
  }
  public SourceBuilder(Boolean validationEnabled) {
    this(new Source(), validationEnabled);
  }
  public SourceBuilder(SourceFluent<?> fluent) {
    this(fluent, false);
  }
  public SourceBuilder(SourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Source(), validationEnabled);
  }
  public SourceBuilder(SourceFluent<?> fluent,Source instance) {
    this(fluent, instance, false);
  }
  public SourceBuilder(SourceFluent<?> fluent,Source instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withIpBlocks(instance.getIpBlocks()); 
    fluent.withNamespaces(instance.getNamespaces()); 
    fluent.withNotIpBlocks(instance.getNotIpBlocks()); 
    fluent.withNotNamespaces(instance.getNotNamespaces()); 
    fluent.withNotPrincipals(instance.getNotPrincipals()); 
    fluent.withNotRemoteIpBlocks(instance.getNotRemoteIpBlocks()); 
    fluent.withNotRequestPrincipals(instance.getNotRequestPrincipals()); 
    fluent.withPrincipals(instance.getPrincipals()); 
    fluent.withRemoteIpBlocks(instance.getRemoteIpBlocks()); 
    fluent.withRequestPrincipals(instance.getRequestPrincipals()); 
    this.validationEnabled = validationEnabled; 
  }
  public SourceBuilder(Source instance) {
    this(instance,false);
  }
  public SourceBuilder(Source instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withIpBlocks(instance.getIpBlocks()); 
    this.withNamespaces(instance.getNamespaces()); 
    this.withNotIpBlocks(instance.getNotIpBlocks()); 
    this.withNotNamespaces(instance.getNotNamespaces()); 
    this.withNotPrincipals(instance.getNotPrincipals()); 
    this.withNotRemoteIpBlocks(instance.getNotRemoteIpBlocks()); 
    this.withNotRequestPrincipals(instance.getNotRequestPrincipals()); 
    this.withPrincipals(instance.getPrincipals()); 
    this.withRemoteIpBlocks(instance.getRemoteIpBlocks()); 
    this.withRequestPrincipals(instance.getRequestPrincipals()); 
    this.validationEnabled = validationEnabled; 
  }
  SourceFluent<?> fluent;
  Boolean validationEnabled;
  public Source build() {
    Source buildable = new Source(fluent.getIpBlocks(),fluent.getNamespaces(),fluent.getNotIpBlocks(),fluent.getNotNamespaces(),fluent.getNotPrincipals(),fluent.getNotRemoteIpBlocks(),fluent.getNotRequestPrincipals(),fluent.getPrincipals(),fluent.getRemoteIpBlocks(),fluent.getRequestPrincipals());
    return buildable;
  }
  
}