package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRetryBuilder extends HTTPRetryFluentImpl<HTTPRetryBuilder> implements VisitableBuilder<HTTPRetry,HTTPRetryBuilder>{
  public HTTPRetryBuilder() {
    this(false);
  }
  public HTTPRetryBuilder(Boolean validationEnabled) {
    this(new HTTPRetry(), validationEnabled);
  }
  public HTTPRetryBuilder(HTTPRetryFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRetryBuilder(HTTPRetryFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPRetry(), validationEnabled);
  }
  public HTTPRetryBuilder(HTTPRetryFluent<?> fluent,HTTPRetry instance) {
    this(fluent, instance, false);
  }
  public HTTPRetryBuilder(HTTPRetryFluent<?> fluent,HTTPRetry instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAttempts(instance.getAttempts()); 
    fluent.withPerTryTimeout(instance.getPerTryTimeout()); 
    fluent.withRetryOn(instance.getRetryOn()); 
    fluent.withRetryRemoteLocalities(instance.getRetryRemoteLocalities()); 
    this.validationEnabled = validationEnabled; 
  }
  public HTTPRetryBuilder(HTTPRetry instance) {
    this(instance,false);
  }
  public HTTPRetryBuilder(HTTPRetry instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAttempts(instance.getAttempts()); 
    this.withPerTryTimeout(instance.getPerTryTimeout()); 
    this.withRetryOn(instance.getRetryOn()); 
    this.withRetryRemoteLocalities(instance.getRetryRemoteLocalities()); 
    this.validationEnabled = validationEnabled; 
  }
  HTTPRetryFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPRetry build() {
    HTTPRetry buildable = new HTTPRetry(fluent.getAttempts(),fluent.getPerTryTimeout(),fluent.getRetryOn(),fluent.getRetryRemoteLocalities());
    return buildable;
  }
  
}