package io.fabric8.istio.api.security.v1beta1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class OperationFluentImpl<A extends OperationFluent<A>> extends BaseFluent<A> implements OperationFluent<A>{
  public OperationFluentImpl() {
  }
  public OperationFluentImpl(Operation instance) {
    this.withHosts(instance.getHosts()); 
    this.withMethods(instance.getMethods()); 
    this.withNotHosts(instance.getNotHosts()); 
    this.withNotMethods(instance.getNotMethods()); 
    this.withNotPaths(instance.getNotPaths()); 
    this.withNotPorts(instance.getNotPorts()); 
    this.withPaths(instance.getPaths()); 
    this.withPorts(instance.getPorts()); 
  }
  private List<String> hosts = new ArrayList<String>();
  private List<String> methods = new ArrayList<String>();
  private List<String> notHosts = new ArrayList<String>();
  private List<String> notMethods = new ArrayList<String>();
  private List<String> notPaths = new ArrayList<String>();
  private List<String> notPorts = new ArrayList<String>();
  private List<String> paths = new ArrayList<String>();
  private List<String> ports = new ArrayList<String>();
  public A addToHosts(Integer index,String item) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    this.hosts.add(index, item);
    return (A)this;
  }
  public A setToHosts(Integer index,String item) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    this.hosts.set(index, item); return (A)this;
  }
  public A addToHosts(java.lang.String... items) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    for (String item : items) {this.hosts.add(item);} return (A)this;
  }
  public A addAllToHosts(Collection<String> items) {
    if (this.hosts == null) {this.hosts = new ArrayList<String>();}
    for (String item : items) {this.hosts.add(item);} return (A)this;
  }
  public A removeFromHosts(java.lang.String... items) {
    for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
  }
  public A removeAllFromHosts(Collection<String> items) {
    for (String item : items) {if (this.hosts!= null){ this.hosts.remove(item);}} return (A)this;
  }
  public List<String> getHosts() {
    return this.hosts;
  }
  public String getHost(Integer index) {
    return this.hosts.get(index);
  }
  public String getFirstHost() {
    return this.hosts.get(0);
  }
  public String getLastHost() {
    return this.hosts.get(hosts.size() - 1);
  }
  public String getMatchingHost(Predicate<String> predicate) {
    for (String item: hosts) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingHost(Predicate<String> predicate) {
    for (String item: hosts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withHosts(List<String> hosts) {
    if (hosts != null) {this.hosts = new ArrayList(); for (String item : hosts){this.addToHosts(item);}} else { this.hosts = null;} return (A) this;
  }
  public A withHosts(java.lang.String... hosts) {
    if (this.hosts != null) {this.hosts.clear();}
    if (hosts != null) {for (String item :hosts){ this.addToHosts(item);}} return (A) this;
  }
  public Boolean hasHosts() {
    return hosts != null && !hosts.isEmpty();
  }
  public A addToMethods(Integer index,String item) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    this.methods.add(index, item);
    return (A)this;
  }
  public A setToMethods(Integer index,String item) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    this.methods.set(index, item); return (A)this;
  }
  public A addToMethods(java.lang.String... items) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    for (String item : items) {this.methods.add(item);} return (A)this;
  }
  public A addAllToMethods(Collection<String> items) {
    if (this.methods == null) {this.methods = new ArrayList<String>();}
    for (String item : items) {this.methods.add(item);} return (A)this;
  }
  public A removeFromMethods(java.lang.String... items) {
    for (String item : items) {if (this.methods!= null){ this.methods.remove(item);}} return (A)this;
  }
  public A removeAllFromMethods(Collection<String> items) {
    for (String item : items) {if (this.methods!= null){ this.methods.remove(item);}} return (A)this;
  }
  public List<String> getMethods() {
    return this.methods;
  }
  public String getMethod(Integer index) {
    return this.methods.get(index);
  }
  public String getFirstMethod() {
    return this.methods.get(0);
  }
  public String getLastMethod() {
    return this.methods.get(methods.size() - 1);
  }
  public String getMatchingMethod(Predicate<String> predicate) {
    for (String item: methods) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingMethod(Predicate<String> predicate) {
    for (String item: methods) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withMethods(List<String> methods) {
    if (methods != null) {this.methods = new ArrayList(); for (String item : methods){this.addToMethods(item);}} else { this.methods = null;} return (A) this;
  }
  public A withMethods(java.lang.String... methods) {
    if (this.methods != null) {this.methods.clear();}
    if (methods != null) {for (String item :methods){ this.addToMethods(item);}} return (A) this;
  }
  public Boolean hasMethods() {
    return methods != null && !methods.isEmpty();
  }
  public A addToNotHosts(Integer index,String item) {
    if (this.notHosts == null) {this.notHosts = new ArrayList<String>();}
    this.notHosts.add(index, item);
    return (A)this;
  }
  public A setToNotHosts(Integer index,String item) {
    if (this.notHosts == null) {this.notHosts = new ArrayList<String>();}
    this.notHosts.set(index, item); return (A)this;
  }
  public A addToNotHosts(java.lang.String... items) {
    if (this.notHosts == null) {this.notHosts = new ArrayList<String>();}
    for (String item : items) {this.notHosts.add(item);} return (A)this;
  }
  public A addAllToNotHosts(Collection<String> items) {
    if (this.notHosts == null) {this.notHosts = new ArrayList<String>();}
    for (String item : items) {this.notHosts.add(item);} return (A)this;
  }
  public A removeFromNotHosts(java.lang.String... items) {
    for (String item : items) {if (this.notHosts!= null){ this.notHosts.remove(item);}} return (A)this;
  }
  public A removeAllFromNotHosts(Collection<String> items) {
    for (String item : items) {if (this.notHosts!= null){ this.notHosts.remove(item);}} return (A)this;
  }
  public List<String> getNotHosts() {
    return this.notHosts;
  }
  public String getNotHost(Integer index) {
    return this.notHosts.get(index);
  }
  public String getFirstNotHost() {
    return this.notHosts.get(0);
  }
  public String getLastNotHost() {
    return this.notHosts.get(notHosts.size() - 1);
  }
  public String getMatchingNotHost(Predicate<String> predicate) {
    for (String item: notHosts) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingNotHost(Predicate<String> predicate) {
    for (String item: notHosts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNotHosts(List<String> notHosts) {
    if (notHosts != null) {this.notHosts = new ArrayList(); for (String item : notHosts){this.addToNotHosts(item);}} else { this.notHosts = null;} return (A) this;
  }
  public A withNotHosts(java.lang.String... notHosts) {
    if (this.notHosts != null) {this.notHosts.clear();}
    if (notHosts != null) {for (String item :notHosts){ this.addToNotHosts(item);}} return (A) this;
  }
  public Boolean hasNotHosts() {
    return notHosts != null && !notHosts.isEmpty();
  }
  public A addToNotMethods(Integer index,String item) {
    if (this.notMethods == null) {this.notMethods = new ArrayList<String>();}
    this.notMethods.add(index, item);
    return (A)this;
  }
  public A setToNotMethods(Integer index,String item) {
    if (this.notMethods == null) {this.notMethods = new ArrayList<String>();}
    this.notMethods.set(index, item); return (A)this;
  }
  public A addToNotMethods(java.lang.String... items) {
    if (this.notMethods == null) {this.notMethods = new ArrayList<String>();}
    for (String item : items) {this.notMethods.add(item);} return (A)this;
  }
  public A addAllToNotMethods(Collection<String> items) {
    if (this.notMethods == null) {this.notMethods = new ArrayList<String>();}
    for (String item : items) {this.notMethods.add(item);} return (A)this;
  }
  public A removeFromNotMethods(java.lang.String... items) {
    for (String item : items) {if (this.notMethods!= null){ this.notMethods.remove(item);}} return (A)this;
  }
  public A removeAllFromNotMethods(Collection<String> items) {
    for (String item : items) {if (this.notMethods!= null){ this.notMethods.remove(item);}} return (A)this;
  }
  public List<String> getNotMethods() {
    return this.notMethods;
  }
  public String getNotMethod(Integer index) {
    return this.notMethods.get(index);
  }
  public String getFirstNotMethod() {
    return this.notMethods.get(0);
  }
  public String getLastNotMethod() {
    return this.notMethods.get(notMethods.size() - 1);
  }
  public String getMatchingNotMethod(Predicate<String> predicate) {
    for (String item: notMethods) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingNotMethod(Predicate<String> predicate) {
    for (String item: notMethods) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNotMethods(List<String> notMethods) {
    if (notMethods != null) {this.notMethods = new ArrayList(); for (String item : notMethods){this.addToNotMethods(item);}} else { this.notMethods = null;} return (A) this;
  }
  public A withNotMethods(java.lang.String... notMethods) {
    if (this.notMethods != null) {this.notMethods.clear();}
    if (notMethods != null) {for (String item :notMethods){ this.addToNotMethods(item);}} return (A) this;
  }
  public Boolean hasNotMethods() {
    return notMethods != null && !notMethods.isEmpty();
  }
  public A addToNotPaths(Integer index,String item) {
    if (this.notPaths == null) {this.notPaths = new ArrayList<String>();}
    this.notPaths.add(index, item);
    return (A)this;
  }
  public A setToNotPaths(Integer index,String item) {
    if (this.notPaths == null) {this.notPaths = new ArrayList<String>();}
    this.notPaths.set(index, item); return (A)this;
  }
  public A addToNotPaths(java.lang.String... items) {
    if (this.notPaths == null) {this.notPaths = new ArrayList<String>();}
    for (String item : items) {this.notPaths.add(item);} return (A)this;
  }
  public A addAllToNotPaths(Collection<String> items) {
    if (this.notPaths == null) {this.notPaths = new ArrayList<String>();}
    for (String item : items) {this.notPaths.add(item);} return (A)this;
  }
  public A removeFromNotPaths(java.lang.String... items) {
    for (String item : items) {if (this.notPaths!= null){ this.notPaths.remove(item);}} return (A)this;
  }
  public A removeAllFromNotPaths(Collection<String> items) {
    for (String item : items) {if (this.notPaths!= null){ this.notPaths.remove(item);}} return (A)this;
  }
  public List<String> getNotPaths() {
    return this.notPaths;
  }
  public String getNotPath(Integer index) {
    return this.notPaths.get(index);
  }
  public String getFirstNotPath() {
    return this.notPaths.get(0);
  }
  public String getLastNotPath() {
    return this.notPaths.get(notPaths.size() - 1);
  }
  public String getMatchingNotPath(Predicate<String> predicate) {
    for (String item: notPaths) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingNotPath(Predicate<String> predicate) {
    for (String item: notPaths) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNotPaths(List<String> notPaths) {
    if (notPaths != null) {this.notPaths = new ArrayList(); for (String item : notPaths){this.addToNotPaths(item);}} else { this.notPaths = null;} return (A) this;
  }
  public A withNotPaths(java.lang.String... notPaths) {
    if (this.notPaths != null) {this.notPaths.clear();}
    if (notPaths != null) {for (String item :notPaths){ this.addToNotPaths(item);}} return (A) this;
  }
  public Boolean hasNotPaths() {
    return notPaths != null && !notPaths.isEmpty();
  }
  public A addToNotPorts(Integer index,String item) {
    if (this.notPorts == null) {this.notPorts = new ArrayList<String>();}
    this.notPorts.add(index, item);
    return (A)this;
  }
  public A setToNotPorts(Integer index,String item) {
    if (this.notPorts == null) {this.notPorts = new ArrayList<String>();}
    this.notPorts.set(index, item); return (A)this;
  }
  public A addToNotPorts(java.lang.String... items) {
    if (this.notPorts == null) {this.notPorts = new ArrayList<String>();}
    for (String item : items) {this.notPorts.add(item);} return (A)this;
  }
  public A addAllToNotPorts(Collection<String> items) {
    if (this.notPorts == null) {this.notPorts = new ArrayList<String>();}
    for (String item : items) {this.notPorts.add(item);} return (A)this;
  }
  public A removeFromNotPorts(java.lang.String... items) {
    for (String item : items) {if (this.notPorts!= null){ this.notPorts.remove(item);}} return (A)this;
  }
  public A removeAllFromNotPorts(Collection<String> items) {
    for (String item : items) {if (this.notPorts!= null){ this.notPorts.remove(item);}} return (A)this;
  }
  public List<String> getNotPorts() {
    return this.notPorts;
  }
  public String getNotPort(Integer index) {
    return this.notPorts.get(index);
  }
  public String getFirstNotPort() {
    return this.notPorts.get(0);
  }
  public String getLastNotPort() {
    return this.notPorts.get(notPorts.size() - 1);
  }
  public String getMatchingNotPort(Predicate<String> predicate) {
    for (String item: notPorts) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingNotPort(Predicate<String> predicate) {
    for (String item: notPorts) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withNotPorts(List<String> notPorts) {
    if (notPorts != null) {this.notPorts = new ArrayList(); for (String item : notPorts){this.addToNotPorts(item);}} else { this.notPorts = null;} return (A) this;
  }
  public A withNotPorts(java.lang.String... notPorts) {
    if (this.notPorts != null) {this.notPorts.clear();}
    if (notPorts != null) {for (String item :notPorts){ this.addToNotPorts(item);}} return (A) this;
  }
  public Boolean hasNotPorts() {
    return notPorts != null && !notPorts.isEmpty();
  }
  public A addToPaths(Integer index,String item) {
    if (this.paths == null) {this.paths = new ArrayList<String>();}
    this.paths.add(index, item);
    return (A)this;
  }
  public A setToPaths(Integer index,String item) {
    if (this.paths == null) {this.paths = new ArrayList<String>();}
    this.paths.set(index, item); return (A)this;
  }
  public A addToPaths(java.lang.String... items) {
    if (this.paths == null) {this.paths = new ArrayList<String>();}
    for (String item : items) {this.paths.add(item);} return (A)this;
  }
  public A addAllToPaths(Collection<String> items) {
    if (this.paths == null) {this.paths = new ArrayList<String>();}
    for (String item : items) {this.paths.add(item);} return (A)this;
  }
  public A removeFromPaths(java.lang.String... items) {
    for (String item : items) {if (this.paths!= null){ this.paths.remove(item);}} return (A)this;
  }
  public A removeAllFromPaths(Collection<String> items) {
    for (String item : items) {if (this.paths!= null){ this.paths.remove(item);}} return (A)this;
  }
  public List<String> getPaths() {
    return this.paths;
  }
  public String getPath(Integer index) {
    return this.paths.get(index);
  }
  public String getFirstPath() {
    return this.paths.get(0);
  }
  public String getLastPath() {
    return this.paths.get(paths.size() - 1);
  }
  public String getMatchingPath(Predicate<String> predicate) {
    for (String item: paths) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingPath(Predicate<String> predicate) {
    for (String item: paths) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPaths(List<String> paths) {
    if (paths != null) {this.paths = new ArrayList(); for (String item : paths){this.addToPaths(item);}} else { this.paths = null;} return (A) this;
  }
  public A withPaths(java.lang.String... paths) {
    if (this.paths != null) {this.paths.clear();}
    if (paths != null) {for (String item :paths){ this.addToPaths(item);}} return (A) this;
  }
  public Boolean hasPaths() {
    return paths != null && !paths.isEmpty();
  }
  public A addToPorts(Integer index,String item) {
    if (this.ports == null) {this.ports = new ArrayList<String>();}
    this.ports.add(index, item);
    return (A)this;
  }
  public A setToPorts(Integer index,String item) {
    if (this.ports == null) {this.ports = new ArrayList<String>();}
    this.ports.set(index, item); return (A)this;
  }
  public A addToPorts(java.lang.String... items) {
    if (this.ports == null) {this.ports = new ArrayList<String>();}
    for (String item : items) {this.ports.add(item);} return (A)this;
  }
  public A addAllToPorts(Collection<String> items) {
    if (this.ports == null) {this.ports = new ArrayList<String>();}
    for (String item : items) {this.ports.add(item);} return (A)this;
  }
  public A removeFromPorts(java.lang.String... items) {
    for (String item : items) {if (this.ports!= null){ this.ports.remove(item);}} return (A)this;
  }
  public A removeAllFromPorts(Collection<String> items) {
    for (String item : items) {if (this.ports!= null){ this.ports.remove(item);}} return (A)this;
  }
  public List<String> getPorts() {
    return this.ports;
  }
  public String getPort(Integer index) {
    return this.ports.get(index);
  }
  public String getFirstPort() {
    return this.ports.get(0);
  }
  public String getLastPort() {
    return this.ports.get(ports.size() - 1);
  }
  public String getMatchingPort(Predicate<String> predicate) {
    for (String item: ports) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingPort(Predicate<String> predicate) {
    for (String item: ports) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPorts(List<String> ports) {
    if (ports != null) {this.ports = new ArrayList(); for (String item : ports){this.addToPorts(item);}} else { this.ports = null;} return (A) this;
  }
  public A withPorts(java.lang.String... ports) {
    if (this.ports != null) {this.ports.clear();}
    if (ports != null) {for (String item :ports){ this.addToPorts(item);}} return (A) this;
  }
  public Boolean hasPorts() {
    return ports != null && !ports.isEmpty();
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    OperationFluentImpl that = (OperationFluentImpl) o;
    if (hosts != null ? !hosts.equals(that.hosts) :that.hosts != null) return false;
    if (methods != null ? !methods.equals(that.methods) :that.methods != null) return false;
    if (notHosts != null ? !notHosts.equals(that.notHosts) :that.notHosts != null) return false;
    if (notMethods != null ? !notMethods.equals(that.notMethods) :that.notMethods != null) return false;
    if (notPaths != null ? !notPaths.equals(that.notPaths) :that.notPaths != null) return false;
    if (notPorts != null ? !notPorts.equals(that.notPorts) :that.notPorts != null) return false;
    if (paths != null ? !paths.equals(that.paths) :that.paths != null) return false;
    if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(hosts,  methods,  notHosts,  notMethods,  notPaths,  notPorts,  paths,  ports,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (hosts != null && !hosts.isEmpty()) { sb.append("hosts:"); sb.append(hosts + ","); }
    if (methods != null && !methods.isEmpty()) { sb.append("methods:"); sb.append(methods + ","); }
    if (notHosts != null && !notHosts.isEmpty()) { sb.append("notHosts:"); sb.append(notHosts + ","); }
    if (notMethods != null && !notMethods.isEmpty()) { sb.append("notMethods:"); sb.append(notMethods + ","); }
    if (notPaths != null && !notPaths.isEmpty()) { sb.append("notPaths:"); sb.append(notPaths + ","); }
    if (notPorts != null && !notPorts.isEmpty()) { sb.append("notPorts:"); sb.append(notPorts + ","); }
    if (paths != null && !paths.isEmpty()) { sb.append("paths:"); sb.append(paths + ","); }
    if (ports != null && !ports.isEmpty()) { sb.append("ports:"); sb.append(ports); }
    sb.append("}");
    return sb.toString();
  }
  
}