package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuthorizationPolicyExtensionProviderBuilder extends AuthorizationPolicyExtensionProviderFluentImpl<AuthorizationPolicyExtensionProviderBuilder> implements VisitableBuilder<AuthorizationPolicyExtensionProvider,AuthorizationPolicyExtensionProviderBuilder>{
  public AuthorizationPolicyExtensionProviderBuilder() {
    this(false);
  }
  public AuthorizationPolicyExtensionProviderBuilder(Boolean validationEnabled) {
    this(new AuthorizationPolicyExtensionProvider(), validationEnabled);
  }
  public AuthorizationPolicyExtensionProviderBuilder(AuthorizationPolicyExtensionProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthorizationPolicyExtensionProviderBuilder(AuthorizationPolicyExtensionProviderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AuthorizationPolicyExtensionProvider(), validationEnabled);
  }
  public AuthorizationPolicyExtensionProviderBuilder(AuthorizationPolicyExtensionProviderFluent<?> fluent,AuthorizationPolicyExtensionProvider instance) {
    this(fluent, instance, false);
  }
  public AuthorizationPolicyExtensionProviderBuilder(AuthorizationPolicyExtensionProviderFluent<?> fluent,AuthorizationPolicyExtensionProvider instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  public AuthorizationPolicyExtensionProviderBuilder(AuthorizationPolicyExtensionProvider instance) {
    this(instance,false);
  }
  public AuthorizationPolicyExtensionProviderBuilder(AuthorizationPolicyExtensionProvider instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.validationEnabled = validationEnabled; 
  }
  AuthorizationPolicyExtensionProviderFluent<?> fluent;
  Boolean validationEnabled;
  public AuthorizationPolicyExtensionProvider build() {
    AuthorizationPolicyExtensionProvider buildable = new AuthorizationPolicyExtensionProvider(fluent.getName());
    return buildable;
  }
  
}