package io.fabric8.istio.api.networking.v1beta1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class WorkloadEntrySpecFluentImpl<A extends WorkloadEntrySpecFluent<A>> extends BaseFluent<A> implements WorkloadEntrySpecFluent<A>{
  public WorkloadEntrySpecFluentImpl() {
  }
  public WorkloadEntrySpecFluentImpl(WorkloadEntrySpec instance) {
    this.withAddress(instance.getAddress()); 
    this.withLabels(instance.getLabels()); 
    this.withLocality(instance.getLocality()); 
    this.withNetwork(instance.getNetwork()); 
    this.withPorts(instance.getPorts()); 
    this.withServiceAccount(instance.getServiceAccount()); 
    this.withWeight(instance.getWeight()); 
  }
  private String address;
  private Map<String,String> labels;
  private String locality;
  private String network;
  private Map<String,Long> ports;
  private String serviceAccount;
  private Integer weight;
  public String getAddress() {
    return this.address;
  }
  public A withAddress(String address) {
    this.address=address; return (A) this;
  }
  public Boolean hasAddress() {
    return this.address != null;
  }
  public A addToLabels(String key,String value) {
    if(this.labels == null && key != null && value != null) { this.labels = new LinkedHashMap(); }
    if(key != null && value != null) {this.labels.put(key, value);} return (A)this;
  }
  public A addToLabels(Map<String,String> map) {
    if(this.labels == null && map != null) { this.labels = new LinkedHashMap(); }
    if(map != null) { this.labels.putAll(map);} return (A)this;
  }
  public A removeFromLabels(String key) {
    if(this.labels == null) { return (A) this; }
    if(key != null && this.labels != null) {this.labels.remove(key);} return (A)this;
  }
  public A removeFromLabels(Map<String,String> map) {
    if(this.labels == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.labels != null){this.labels.remove(key);}}} return (A)this;
  }
  public Map<String,String> getLabels() {
    return this.labels;
  }
  public <K,V>A withLabels(Map<String,String> labels) {
    if (labels == null) { this.labels =  null;} else {this.labels = new LinkedHashMap(labels);} return (A) this;
  }
  public Boolean hasLabels() {
    return this.labels != null;
  }
  public String getLocality() {
    return this.locality;
  }
  public A withLocality(String locality) {
    this.locality=locality; return (A) this;
  }
  public Boolean hasLocality() {
    return this.locality != null;
  }
  public String getNetwork() {
    return this.network;
  }
  public A withNetwork(String network) {
    this.network=network; return (A) this;
  }
  public Boolean hasNetwork() {
    return this.network != null;
  }
  public A addToPorts(String key,Long value) {
    if(this.ports == null && key != null && value != null) { this.ports = new LinkedHashMap(); }
    if(key != null && value != null) {this.ports.put(key, value);} return (A)this;
  }
  public A addToPorts(Map<String,Long> map) {
    if(this.ports == null && map != null) { this.ports = new LinkedHashMap(); }
    if(map != null) { this.ports.putAll(map);} return (A)this;
  }
  public A removeFromPorts(String key) {
    if(this.ports == null) { return (A) this; }
    if(key != null && this.ports != null) {this.ports.remove(key);} return (A)this;
  }
  public A removeFromPorts(Map<String,Long> map) {
    if(this.ports == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.ports != null){this.ports.remove(key);}}} return (A)this;
  }
  public Map<String,Long> getPorts() {
    return this.ports;
  }
  public <K,V>A withPorts(Map<String,Long> ports) {
    if (ports == null) { this.ports =  null;} else {this.ports = new LinkedHashMap(ports);} return (A) this;
  }
  public Boolean hasPorts() {
    return this.ports != null;
  }
  public String getServiceAccount() {
    return this.serviceAccount;
  }
  public A withServiceAccount(String serviceAccount) {
    this.serviceAccount=serviceAccount; return (A) this;
  }
  public Boolean hasServiceAccount() {
    return this.serviceAccount != null;
  }
  public Integer getWeight() {
    return this.weight;
  }
  public A withWeight(Integer weight) {
    this.weight=weight; return (A) this;
  }
  public Boolean hasWeight() {
    return this.weight != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WorkloadEntrySpecFluentImpl that = (WorkloadEntrySpecFluentImpl) o;
    if (address != null ? !address.equals(that.address) :that.address != null) return false;
    if (labels != null ? !labels.equals(that.labels) :that.labels != null) return false;
    if (locality != null ? !locality.equals(that.locality) :that.locality != null) return false;
    if (network != null ? !network.equals(that.network) :that.network != null) return false;
    if (ports != null ? !ports.equals(that.ports) :that.ports != null) return false;
    if (serviceAccount != null ? !serviceAccount.equals(that.serviceAccount) :that.serviceAccount != null) return false;
    if (weight != null ? !weight.equals(that.weight) :that.weight != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(address,  labels,  locality,  network,  ports,  serviceAccount,  weight,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (address != null) { sb.append("address:"); sb.append(address + ","); }
    if (labels != null && !labels.isEmpty()) { sb.append("labels:"); sb.append(labels + ","); }
    if (locality != null) { sb.append("locality:"); sb.append(locality + ","); }
    if (network != null) { sb.append("network:"); sb.append(network + ","); }
    if (ports != null && !ports.isEmpty()) { sb.append("ports:"); sb.append(ports + ","); }
    if (serviceAccount != null) { sb.append("serviceAccount:"); sb.append(serviceAccount + ","); }
    if (weight != null) { sb.append("weight:"); sb.append(weight); }
    sb.append("}");
    return sb.toString();
  }
  
}