package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ServiceEntryListBuilder extends ServiceEntryListFluentImpl<ServiceEntryListBuilder> implements VisitableBuilder<ServiceEntryList,ServiceEntryListBuilder>{
  public ServiceEntryListBuilder() {
    this(false);
  }
  public ServiceEntryListBuilder(Boolean validationEnabled) {
    this(new ServiceEntryList(), validationEnabled);
  }
  public ServiceEntryListBuilder(ServiceEntryListFluent<?> fluent) {
    this(fluent, false);
  }
  public ServiceEntryListBuilder(ServiceEntryListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ServiceEntryList(), validationEnabled);
  }
  public ServiceEntryListBuilder(ServiceEntryListFluent<?> fluent,ServiceEntryList instance) {
    this(fluent, instance, false);
  }
  public ServiceEntryListBuilder(ServiceEntryListFluent<?> fluent,ServiceEntryList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  public ServiceEntryListBuilder(ServiceEntryList instance) {
    this(instance,false);
  }
  public ServiceEntryListBuilder(ServiceEntryList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.validationEnabled = validationEnabled; 
  }
  ServiceEntryListFluent<?> fluent;
  Boolean validationEnabled;
  public ServiceEntryList build() {
    ServiceEntryList buildable = new ServiceEntryList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    return buildable;
  }
  
}