package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AuthorizationPolicyProviderBuilder extends AuthorizationPolicyProviderFluentImpl<AuthorizationPolicyProviderBuilder> implements VisitableBuilder<AuthorizationPolicyProvider,AuthorizationPolicyProviderBuilder>{
  public AuthorizationPolicyProviderBuilder() {
    this(false);
  }
  public AuthorizationPolicyProviderBuilder(Boolean validationEnabled) {
    this(new AuthorizationPolicyProvider(), validationEnabled);
  }
  public AuthorizationPolicyProviderBuilder(AuthorizationPolicyProviderFluent<?> fluent) {
    this(fluent, false);
  }
  public AuthorizationPolicyProviderBuilder(AuthorizationPolicyProviderFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AuthorizationPolicyProvider(), validationEnabled);
  }
  public AuthorizationPolicyProviderBuilder(AuthorizationPolicyProviderFluent<?> fluent,AuthorizationPolicyProvider instance) {
    this(fluent, instance, false);
  }
  public AuthorizationPolicyProviderBuilder(AuthorizationPolicyProviderFluent<?> fluent,AuthorizationPolicyProvider instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withProvider(instance.getProvider()); 
    this.validationEnabled = validationEnabled; 
  }
  public AuthorizationPolicyProviderBuilder(AuthorizationPolicyProvider instance) {
    this(instance,false);
  }
  public AuthorizationPolicyProviderBuilder(AuthorizationPolicyProvider instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withProvider(instance.getProvider()); 
    this.validationEnabled = validationEnabled; 
  }
  AuthorizationPolicyProviderFluent<?> fluent;
  Boolean validationEnabled;
  public AuthorizationPolicyProvider build() {
    AuthorizationPolicyProvider buildable = new AuthorizationPolicyProvider(fluent.getProvider());
    return buildable;
  }
  
}