package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TrafficPolicyFluentImpl<A extends TrafficPolicyFluent<A>> extends BaseFluent<A> implements TrafficPolicyFluent<A>{
  public TrafficPolicyFluentImpl() {
  }
  public TrafficPolicyFluentImpl(TrafficPolicy instance) {
    this.withConnectionPool(instance.getConnectionPool()); 
    this.withLoadBalancer(instance.getLoadBalancer()); 
    this.withOutlierDetection(instance.getOutlierDetection()); 
    this.withPortLevelSettings(instance.getPortLevelSettings()); 
    this.withTls(instance.getTls()); 
  }
  private ConnectionPoolSettingsBuilder connectionPool;
  private LoadBalancerSettingsBuilder loadBalancer;
  private OutlierDetectionBuilder outlierDetection;
  private ArrayList<TrafficPolicyPortTrafficPolicyBuilder> portLevelSettings = new ArrayList<TrafficPolicyPortTrafficPolicyBuilder>();
  private ClientTLSSettingsBuilder tls;
  
  /**
   * This method has been deprecated, please use method buildConnectionPool instead.
   * @return The buildable object.
   */
  @Deprecated
  public ConnectionPoolSettings getConnectionPool() {
    return this.connectionPool!=null ?this.connectionPool.build():null;
  }
  public ConnectionPoolSettings buildConnectionPool() {
    return this.connectionPool!=null ?this.connectionPool.build():null;
  }
  public A withConnectionPool(ConnectionPoolSettings connectionPool) {
    _visitables.get("connectionPool").remove(this.connectionPool);
    if (connectionPool!=null){ this.connectionPool= new ConnectionPoolSettingsBuilder(connectionPool); _visitables.get("connectionPool").add(this.connectionPool);} else { this.connectionPool = null; _visitables.get("connectionPool").remove(this.connectionPool); } return (A) this;
  }
  public Boolean hasConnectionPool() {
    return this.connectionPool != null;
  }
  public TrafficPolicyFluent.ConnectionPoolNested<A> withNewConnectionPool() {
    return new TrafficPolicyFluentImpl.ConnectionPoolNestedImpl();
  }
  public TrafficPolicyFluent.ConnectionPoolNested<A> withNewConnectionPoolLike(ConnectionPoolSettings item) {
    return new TrafficPolicyFluentImpl.ConnectionPoolNestedImpl(item);
  }
  public TrafficPolicyFluent.ConnectionPoolNested<A> editConnectionPool() {
    return withNewConnectionPoolLike(getConnectionPool());
  }
  public TrafficPolicyFluent.ConnectionPoolNested<A> editOrNewConnectionPool() {
    return withNewConnectionPoolLike(getConnectionPool() != null ? getConnectionPool(): new ConnectionPoolSettingsBuilder().build());
  }
  public TrafficPolicyFluent.ConnectionPoolNested<A> editOrNewConnectionPoolLike(ConnectionPoolSettings item) {
    return withNewConnectionPoolLike(getConnectionPool() != null ? getConnectionPool(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildLoadBalancer instead.
   * @return The buildable object.
   */
  @Deprecated
  public LoadBalancerSettings getLoadBalancer() {
    return this.loadBalancer!=null ?this.loadBalancer.build():null;
  }
  public LoadBalancerSettings buildLoadBalancer() {
    return this.loadBalancer!=null ?this.loadBalancer.build():null;
  }
  public A withLoadBalancer(LoadBalancerSettings loadBalancer) {
    _visitables.get("loadBalancer").remove(this.loadBalancer);
    if (loadBalancer!=null){ this.loadBalancer= new LoadBalancerSettingsBuilder(loadBalancer); _visitables.get("loadBalancer").add(this.loadBalancer);} else { this.loadBalancer = null; _visitables.get("loadBalancer").remove(this.loadBalancer); } return (A) this;
  }
  public Boolean hasLoadBalancer() {
    return this.loadBalancer != null;
  }
  public TrafficPolicyFluent.LoadBalancerNested<A> withNewLoadBalancer() {
    return new TrafficPolicyFluentImpl.LoadBalancerNestedImpl();
  }
  public TrafficPolicyFluent.LoadBalancerNested<A> withNewLoadBalancerLike(LoadBalancerSettings item) {
    return new TrafficPolicyFluentImpl.LoadBalancerNestedImpl(item);
  }
  public TrafficPolicyFluent.LoadBalancerNested<A> editLoadBalancer() {
    return withNewLoadBalancerLike(getLoadBalancer());
  }
  public TrafficPolicyFluent.LoadBalancerNested<A> editOrNewLoadBalancer() {
    return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): new LoadBalancerSettingsBuilder().build());
  }
  public TrafficPolicyFluent.LoadBalancerNested<A> editOrNewLoadBalancerLike(LoadBalancerSettings item) {
    return withNewLoadBalancerLike(getLoadBalancer() != null ? getLoadBalancer(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildOutlierDetection instead.
   * @return The buildable object.
   */
  @Deprecated
  public OutlierDetection getOutlierDetection() {
    return this.outlierDetection!=null ?this.outlierDetection.build():null;
  }
  public OutlierDetection buildOutlierDetection() {
    return this.outlierDetection!=null ?this.outlierDetection.build():null;
  }
  public A withOutlierDetection(OutlierDetection outlierDetection) {
    _visitables.get("outlierDetection").remove(this.outlierDetection);
    if (outlierDetection!=null){ this.outlierDetection= new OutlierDetectionBuilder(outlierDetection); _visitables.get("outlierDetection").add(this.outlierDetection);} else { this.outlierDetection = null; _visitables.get("outlierDetection").remove(this.outlierDetection); } return (A) this;
  }
  public Boolean hasOutlierDetection() {
    return this.outlierDetection != null;
  }
  public TrafficPolicyFluent.OutlierDetectionNested<A> withNewOutlierDetection() {
    return new TrafficPolicyFluentImpl.OutlierDetectionNestedImpl();
  }
  public TrafficPolicyFluent.OutlierDetectionNested<A> withNewOutlierDetectionLike(OutlierDetection item) {
    return new TrafficPolicyFluentImpl.OutlierDetectionNestedImpl(item);
  }
  public TrafficPolicyFluent.OutlierDetectionNested<A> editOutlierDetection() {
    return withNewOutlierDetectionLike(getOutlierDetection());
  }
  public TrafficPolicyFluent.OutlierDetectionNested<A> editOrNewOutlierDetection() {
    return withNewOutlierDetectionLike(getOutlierDetection() != null ? getOutlierDetection(): new OutlierDetectionBuilder().build());
  }
  public TrafficPolicyFluent.OutlierDetectionNested<A> editOrNewOutlierDetectionLike(OutlierDetection item) {
    return withNewOutlierDetectionLike(getOutlierDetection() != null ? getOutlierDetection(): item);
  }
  public A addToPortLevelSettings(Integer index,TrafficPolicyPortTrafficPolicy item) {
    if (this.portLevelSettings == null) {this.portLevelSettings = new ArrayList<TrafficPolicyPortTrafficPolicyBuilder>();}
    TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);_visitables.get("portLevelSettings").add(index >= 0 ? index : _visitables.get("portLevelSettings").size(), builder);this.portLevelSettings.add(index >= 0 ? index : portLevelSettings.size(), builder); return (A)this;
  }
  public A setToPortLevelSettings(Integer index,TrafficPolicyPortTrafficPolicy item) {
    if (this.portLevelSettings == null) {this.portLevelSettings = new ArrayList<TrafficPolicyPortTrafficPolicyBuilder>();}
    TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);
    if (index < 0 || index >= _visitables.get("portLevelSettings").size()) { _visitables.get("portLevelSettings").add(builder); } else { _visitables.get("portLevelSettings").set(index, builder);}
    if (index < 0 || index >= portLevelSettings.size()) { portLevelSettings.add(builder); } else { portLevelSettings.set(index, builder);}
     return (A)this;
  }
  public A addToPortLevelSettings(io.fabric8.istio.api.networking.v1beta1.TrafficPolicyPortTrafficPolicy... items) {
    if (this.portLevelSettings == null) {this.portLevelSettings = new ArrayList<TrafficPolicyPortTrafficPolicyBuilder>();}
    for (TrafficPolicyPortTrafficPolicy item : items) {TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);_visitables.get("portLevelSettings").add(builder);this.portLevelSettings.add(builder);} return (A)this;
  }
  public A addAllToPortLevelSettings(Collection<TrafficPolicyPortTrafficPolicy> items) {
    if (this.portLevelSettings == null) {this.portLevelSettings = new ArrayList<TrafficPolicyPortTrafficPolicyBuilder>();}
    for (TrafficPolicyPortTrafficPolicy item : items) {TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);_visitables.get("portLevelSettings").add(builder);this.portLevelSettings.add(builder);} return (A)this;
  }
  public A removeFromPortLevelSettings(io.fabric8.istio.api.networking.v1beta1.TrafficPolicyPortTrafficPolicy... items) {
    for (TrafficPolicyPortTrafficPolicy item : items) {TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);_visitables.get("portLevelSettings").remove(builder);if (this.portLevelSettings != null) {this.portLevelSettings.remove(builder);}} return (A)this;
  }
  public A removeAllFromPortLevelSettings(Collection<TrafficPolicyPortTrafficPolicy> items) {
    for (TrafficPolicyPortTrafficPolicy item : items) {TrafficPolicyPortTrafficPolicyBuilder builder = new TrafficPolicyPortTrafficPolicyBuilder(item);_visitables.get("portLevelSettings").remove(builder);if (this.portLevelSettings != null) {this.portLevelSettings.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPortLevelSettings(Predicate<TrafficPolicyPortTrafficPolicyBuilder> predicate) {
    if (portLevelSettings == null) return (A) this;
    final Iterator<TrafficPolicyPortTrafficPolicyBuilder> each = portLevelSettings.iterator();
    final List visitables = _visitables.get("portLevelSettings");
    while (each.hasNext()) {
      TrafficPolicyPortTrafficPolicyBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPortLevelSettings instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<TrafficPolicyPortTrafficPolicy> getPortLevelSettings() {
    return portLevelSettings != null ? build(portLevelSettings) : null;
  }
  public List<TrafficPolicyPortTrafficPolicy> buildPortLevelSettings() {
    return portLevelSettings != null ? build(portLevelSettings) : null;
  }
  public TrafficPolicyPortTrafficPolicy buildPortLevelSetting(Integer index) {
    return this.portLevelSettings.get(index).build();
  }
  public TrafficPolicyPortTrafficPolicy buildFirstPortLevelSetting() {
    return this.portLevelSettings.get(0).build();
  }
  public TrafficPolicyPortTrafficPolicy buildLastPortLevelSetting() {
    return this.portLevelSettings.get(portLevelSettings.size() - 1).build();
  }
  public TrafficPolicyPortTrafficPolicy buildMatchingPortLevelSetting(Predicate<TrafficPolicyPortTrafficPolicyBuilder> predicate) {
    for (TrafficPolicyPortTrafficPolicyBuilder item: portLevelSettings) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPortLevelSetting(Predicate<TrafficPolicyPortTrafficPolicyBuilder> predicate) {
    for (TrafficPolicyPortTrafficPolicyBuilder item: portLevelSettings) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPortLevelSettings(List<TrafficPolicyPortTrafficPolicy> portLevelSettings) {
    if (this.portLevelSettings != null) { _visitables.get("portLevelSettings").removeAll(this.portLevelSettings);}
    if (portLevelSettings != null) {this.portLevelSettings = new ArrayList(); for (TrafficPolicyPortTrafficPolicy item : portLevelSettings){this.addToPortLevelSettings(item);}} else { this.portLevelSettings = null;} return (A) this;
  }
  public A withPortLevelSettings(io.fabric8.istio.api.networking.v1beta1.TrafficPolicyPortTrafficPolicy... portLevelSettings) {
    if (this.portLevelSettings != null) {this.portLevelSettings.clear();}
    if (portLevelSettings != null) {for (TrafficPolicyPortTrafficPolicy item :portLevelSettings){ this.addToPortLevelSettings(item);}} return (A) this;
  }
  public Boolean hasPortLevelSettings() {
    return portLevelSettings != null && !portLevelSettings.isEmpty();
  }
  public TrafficPolicyFluent.PortLevelSettingsNested<A> addNewPortLevelSetting() {
    return new TrafficPolicyFluentImpl.PortLevelSettingsNestedImpl();
  }
  public TrafficPolicyFluent.PortLevelSettingsNested<A> addNewPortLevelSettingLike(TrafficPolicyPortTrafficPolicy item) {
    return new TrafficPolicyFluentImpl.PortLevelSettingsNestedImpl(-1, item);
  }
  public TrafficPolicyFluent.PortLevelSettingsNested<A> setNewPortLevelSettingLike(Integer index,TrafficPolicyPortTrafficPolicy item) {
    return new TrafficPolicyFluentImpl.PortLevelSettingsNestedImpl(index, item);
  }
  public TrafficPolicyFluent.PortLevelSettingsNested<A> editPortLevelSetting(Integer index) {
    if (portLevelSettings.size() <= index) throw new RuntimeException("Can't edit portLevelSettings. Index exceeds size.");
    return setNewPortLevelSettingLike(index, buildPortLevelSetting(index));
  }
  public TrafficPolicyFluent.PortLevelSettingsNested<A> editFirstPortLevelSetting() {
    if (portLevelSettings.size() == 0) throw new RuntimeException("Can't edit first portLevelSettings. The list is empty.");
    return setNewPortLevelSettingLike(0, buildPortLevelSetting(0));
  }
  public TrafficPolicyFluent.PortLevelSettingsNested<A> editLastPortLevelSetting() {
    int index = portLevelSettings.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last portLevelSettings. The list is empty.");
    return setNewPortLevelSettingLike(index, buildPortLevelSetting(index));
  }
  public TrafficPolicyFluent.PortLevelSettingsNested<A> editMatchingPortLevelSetting(Predicate<TrafficPolicyPortTrafficPolicyBuilder> predicate) {
    int index = -1;
    for (int i=0;i<portLevelSettings.size();i++) { 
    if (predicate.test(portLevelSettings.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching portLevelSettings. No match found.");
    return setNewPortLevelSettingLike(index, buildPortLevelSetting(index));
  }
  
  /**
   * This method has been deprecated, please use method buildTls instead.
   * @return The buildable object.
   */
  @Deprecated
  public ClientTLSSettings getTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  public ClientTLSSettings buildTls() {
    return this.tls!=null ?this.tls.build():null;
  }
  public A withTls(ClientTLSSettings tls) {
    _visitables.get("tls").remove(this.tls);
    if (tls!=null){ this.tls= new ClientTLSSettingsBuilder(tls); _visitables.get("tls").add(this.tls);} else { this.tls = null; _visitables.get("tls").remove(this.tls); } return (A) this;
  }
  public Boolean hasTls() {
    return this.tls != null;
  }
  public TrafficPolicyFluent.TlsNested<A> withNewTls() {
    return new TrafficPolicyFluentImpl.TlsNestedImpl();
  }
  public TrafficPolicyFluent.TlsNested<A> withNewTlsLike(ClientTLSSettings item) {
    return new TrafficPolicyFluentImpl.TlsNestedImpl(item);
  }
  public TrafficPolicyFluent.TlsNested<A> editTls() {
    return withNewTlsLike(getTls());
  }
  public TrafficPolicyFluent.TlsNested<A> editOrNewTls() {
    return withNewTlsLike(getTls() != null ? getTls(): new ClientTLSSettingsBuilder().build());
  }
  public TrafficPolicyFluent.TlsNested<A> editOrNewTlsLike(ClientTLSSettings item) {
    return withNewTlsLike(getTls() != null ? getTls(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    TrafficPolicyFluentImpl that = (TrafficPolicyFluentImpl) o;
    if (connectionPool != null ? !connectionPool.equals(that.connectionPool) :that.connectionPool != null) return false;
    if (loadBalancer != null ? !loadBalancer.equals(that.loadBalancer) :that.loadBalancer != null) return false;
    if (outlierDetection != null ? !outlierDetection.equals(that.outlierDetection) :that.outlierDetection != null) return false;
    if (portLevelSettings != null ? !portLevelSettings.equals(that.portLevelSettings) :that.portLevelSettings != null) return false;
    if (tls != null ? !tls.equals(that.tls) :that.tls != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(connectionPool,  loadBalancer,  outlierDetection,  portLevelSettings,  tls,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (connectionPool != null) { sb.append("connectionPool:"); sb.append(connectionPool + ","); }
    if (loadBalancer != null) { sb.append("loadBalancer:"); sb.append(loadBalancer + ","); }
    if (outlierDetection != null) { sb.append("outlierDetection:"); sb.append(outlierDetection + ","); }
    if (portLevelSettings != null && !portLevelSettings.isEmpty()) { sb.append("portLevelSettings:"); sb.append(portLevelSettings + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls); }
    sb.append("}");
    return sb.toString();
  }
  class ConnectionPoolNestedImpl<N> extends ConnectionPoolSettingsFluentImpl<TrafficPolicyFluent.ConnectionPoolNested<N>> implements TrafficPolicyFluent.ConnectionPoolNested<N>,Nested<N>{
    ConnectionPoolNestedImpl(ConnectionPoolSettings item) {
      this.builder = new ConnectionPoolSettingsBuilder(this, item);
    }
    ConnectionPoolNestedImpl() {
      this.builder = new ConnectionPoolSettingsBuilder(this);
    }
    ConnectionPoolSettingsBuilder builder;
    public N and() {
      return (N) TrafficPolicyFluentImpl.this.withConnectionPool(builder.build());
    }
    public N endConnectionPool() {
      return and();
    }
    
  }
  class LoadBalancerNestedImpl<N> extends LoadBalancerSettingsFluentImpl<TrafficPolicyFluent.LoadBalancerNested<N>> implements TrafficPolicyFluent.LoadBalancerNested<N>,Nested<N>{
    LoadBalancerNestedImpl(LoadBalancerSettings item) {
      this.builder = new LoadBalancerSettingsBuilder(this, item);
    }
    LoadBalancerNestedImpl() {
      this.builder = new LoadBalancerSettingsBuilder(this);
    }
    LoadBalancerSettingsBuilder builder;
    public N and() {
      return (N) TrafficPolicyFluentImpl.this.withLoadBalancer(builder.build());
    }
    public N endLoadBalancer() {
      return and();
    }
    
  }
  class OutlierDetectionNestedImpl<N> extends OutlierDetectionFluentImpl<TrafficPolicyFluent.OutlierDetectionNested<N>> implements TrafficPolicyFluent.OutlierDetectionNested<N>,Nested<N>{
    OutlierDetectionNestedImpl(OutlierDetection item) {
      this.builder = new OutlierDetectionBuilder(this, item);
    }
    OutlierDetectionNestedImpl() {
      this.builder = new OutlierDetectionBuilder(this);
    }
    OutlierDetectionBuilder builder;
    public N and() {
      return (N) TrafficPolicyFluentImpl.this.withOutlierDetection(builder.build());
    }
    public N endOutlierDetection() {
      return and();
    }
    
  }
  class PortLevelSettingsNestedImpl<N> extends TrafficPolicyPortTrafficPolicyFluentImpl<TrafficPolicyFluent.PortLevelSettingsNested<N>> implements TrafficPolicyFluent.PortLevelSettingsNested<N>,Nested<N>{
    PortLevelSettingsNestedImpl(Integer index,TrafficPolicyPortTrafficPolicy item) {
      this.index = index;
      this.builder = new TrafficPolicyPortTrafficPolicyBuilder(this, item);
    }
    PortLevelSettingsNestedImpl() {
      this.index = -1;
      this.builder = new TrafficPolicyPortTrafficPolicyBuilder(this);
    }
    TrafficPolicyPortTrafficPolicyBuilder builder;
    Integer index;
    public N and() {
      return (N) TrafficPolicyFluentImpl.this.setToPortLevelSettings(index,builder.build());
    }
    public N endPortLevelSetting() {
      return and();
    }
    
  }
  class TlsNestedImpl<N> extends ClientTLSSettingsFluentImpl<TrafficPolicyFluent.TlsNested<N>> implements TrafficPolicyFluent.TlsNested<N>,Nested<N>{
    TlsNestedImpl(ClientTLSSettings item) {
      this.builder = new ClientTLSSettingsBuilder(this, item);
    }
    TlsNestedImpl() {
      this.builder = new ClientTLSSettingsBuilder(this);
    }
    ClientTLSSettingsBuilder builder;
    public N and() {
      return (N) TrafficPolicyFluentImpl.this.withTls(builder.build());
    }
    public N endTls() {
      return and();
    }
    
  }
  
}