package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HTTPRedirectBuilder extends HTTPRedirectFluentImpl<HTTPRedirectBuilder> implements VisitableBuilder<HTTPRedirect,HTTPRedirectBuilder>{
  public HTTPRedirectBuilder() {
    this(false);
  }
  public HTTPRedirectBuilder(Boolean validationEnabled) {
    this(new HTTPRedirect(), validationEnabled);
  }
  public HTTPRedirectBuilder(HTTPRedirectFluent<?> fluent) {
    this(fluent, false);
  }
  public HTTPRedirectBuilder(HTTPRedirectFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HTTPRedirect(), validationEnabled);
  }
  public HTTPRedirectBuilder(HTTPRedirectFluent<?> fluent,HTTPRedirect instance) {
    this(fluent, instance, false);
  }
  public HTTPRedirectBuilder(HTTPRedirectFluent<?> fluent,HTTPRedirect instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRedirectPort(instance.getRedirectPort()); 
    fluent.withAuthority(instance.getAuthority()); 
    fluent.withRedirectCode(instance.getRedirectCode()); 
    fluent.withScheme(instance.getScheme()); 
    fluent.withUri(instance.getUri()); 
    this.validationEnabled = validationEnabled; 
  }
  public HTTPRedirectBuilder(HTTPRedirect instance) {
    this(instance,false);
  }
  public HTTPRedirectBuilder(HTTPRedirect instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRedirectPort(instance.getRedirectPort()); 
    this.withAuthority(instance.getAuthority()); 
    this.withRedirectCode(instance.getRedirectCode()); 
    this.withScheme(instance.getScheme()); 
    this.withUri(instance.getUri()); 
    this.validationEnabled = validationEnabled; 
  }
  HTTPRedirectFluent<?> fluent;
  Boolean validationEnabled;
  public HTTPRedirect build() {
    HTTPRedirect buildable = new HTTPRedirect(fluent.getRedirectPort(),fluent.getAuthority(),fluent.getRedirectCode(),fluent.getScheme(),fluent.getUri());
    return buildable;
  }
  
}