package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RuleBuilder extends RuleFluentImpl<RuleBuilder> implements VisitableBuilder<Rule,RuleBuilder>{
  public RuleBuilder() {
    this(false);
  }
  public RuleBuilder(Boolean validationEnabled) {
    this(new Rule(), validationEnabled);
  }
  public RuleBuilder(RuleFluent<?> fluent) {
    this(fluent, false);
  }
  public RuleBuilder(RuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Rule(), validationEnabled);
  }
  public RuleBuilder(RuleFluent<?> fluent,Rule instance) {
    this(fluent, instance, false);
  }
  public RuleBuilder(RuleFluent<?> fluent,Rule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withFrom(instance.getFrom()); 
    fluent.withTo(instance.getTo()); 
    fluent.withWhen(instance.getWhen()); 
    this.validationEnabled = validationEnabled; 
  }
  public RuleBuilder(Rule instance) {
    this(instance,false);
  }
  public RuleBuilder(Rule instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withFrom(instance.getFrom()); 
    this.withTo(instance.getTo()); 
    this.withWhen(instance.getWhen()); 
    this.validationEnabled = validationEnabled; 
  }
  RuleFluent<?> fluent;
  Boolean validationEnabled;
  public Rule build() {
    Rule buildable = new Rule(fluent.getFrom(),fluent.getTo(),fluent.getWhen());
    return buildable;
  }
  
}