package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PeerAuthenticationSpecBuilder extends PeerAuthenticationSpecFluentImpl<PeerAuthenticationSpecBuilder> implements VisitableBuilder<PeerAuthenticationSpec,PeerAuthenticationSpecBuilder>{
  public PeerAuthenticationSpecBuilder() {
    this(false);
  }
  public PeerAuthenticationSpecBuilder(Boolean validationEnabled) {
    this(new PeerAuthenticationSpec(), validationEnabled);
  }
  public PeerAuthenticationSpecBuilder(PeerAuthenticationSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public PeerAuthenticationSpecBuilder(PeerAuthenticationSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PeerAuthenticationSpec(), validationEnabled);
  }
  public PeerAuthenticationSpecBuilder(PeerAuthenticationSpecFluent<?> fluent,PeerAuthenticationSpec instance) {
    this(fluent, instance, false);
  }
  public PeerAuthenticationSpecBuilder(PeerAuthenticationSpecFluent<?> fluent,PeerAuthenticationSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMtls(instance.getMtls()); 
    fluent.withPortLevelMtls(instance.getPortLevelMtls()); 
    fluent.withSelector(instance.getSelector()); 
    this.validationEnabled = validationEnabled; 
  }
  public PeerAuthenticationSpecBuilder(PeerAuthenticationSpec instance) {
    this(instance,false);
  }
  public PeerAuthenticationSpecBuilder(PeerAuthenticationSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMtls(instance.getMtls()); 
    this.withPortLevelMtls(instance.getPortLevelMtls()); 
    this.withSelector(instance.getSelector()); 
    this.validationEnabled = validationEnabled; 
  }
  PeerAuthenticationSpecFluent<?> fluent;
  Boolean validationEnabled;
  public PeerAuthenticationSpec build() {
    PeerAuthenticationSpec buildable = new PeerAuthenticationSpec(fluent.getMtls(),fluent.getPortLevelMtls(),fluent.getSelector());
    return buildable;
  }
  
}