package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StringMatchBuilder extends StringMatchFluentImpl<StringMatchBuilder> implements VisitableBuilder<StringMatch,StringMatchBuilder>{
  public StringMatchBuilder() {
    this(false);
  }
  public StringMatchBuilder(Boolean validationEnabled) {
    this(new StringMatch(), validationEnabled);
  }
  public StringMatchBuilder(StringMatchFluent<?> fluent) {
    this(fluent, false);
  }
  public StringMatchBuilder(StringMatchFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StringMatch(), validationEnabled);
  }
  public StringMatchBuilder(StringMatchFluent<?> fluent,StringMatch instance) {
    this(fluent, instance, false);
  }
  public StringMatchBuilder(StringMatchFluent<?> fluent,StringMatch instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMatchType(instance.getMatchType()); 
    this.validationEnabled = validationEnabled; 
  }
  public StringMatchBuilder(StringMatch instance) {
    this(instance,false);
  }
  public StringMatchBuilder(StringMatch instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMatchType(instance.getMatchType()); 
    this.validationEnabled = validationEnabled; 
  }
  StringMatchFluent<?> fluent;
  Boolean validationEnabled;
  public StringMatch build() {
    StringMatch buildable = new StringMatch(fluent.getMatchType());
    return buildable;
  }
  
}