/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.type.v1beta1;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.HashMap;
import java.util.Map;

public enum WorkloadMode {
    UNDEFINED(0),
    CLIENT(1),
    SERVER(2),
    CLIENT_AND_SERVER(3);

    private final Integer value;
    private static final Map<Integer, WorkloadMode> CONSTANTS;
    private static final Map<String, WorkloadMode> NAME_CONSTANTS;

    private WorkloadMode(Integer value) {
        this.value = value;
    }

    @JsonCreator
    public static WorkloadMode fromValue(Object value) {
        if (value instanceof String) {
            WorkloadMode constant = NAME_CONSTANTS.get(((String)value).toLowerCase());
            if (constant == null) {
                throw new IllegalArgumentException(value + "");
            }
            return constant;
        }
        WorkloadMode constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value + "");
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<Integer, WorkloadMode>();
        NAME_CONSTANTS = new HashMap<String, WorkloadMode>();
        for (WorkloadMode c : WorkloadMode.values()) {
            CONSTANTS.put(c.value, c);
        }
        for (WorkloadMode c : WorkloadMode.values()) {
            NAME_CONSTANTS.put(c.name().toLowerCase(), c);
        }
    }
}

