package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class JWTRuleFluent<A extends JWTRuleFluent<A>> extends BaseFluent<A>{
  public JWTRuleFluent() {
  }
  
  public JWTRuleFluent(JWTRule instance) {
    this.copyInstance(instance);
  }
  private List<String> audiences = new ArrayList<String>();
  private Boolean forwardOriginalToken;
  private List<String> fromCookies = new ArrayList<String>();
  private ArrayList<JWTHeaderBuilder> fromHeaders = new ArrayList<JWTHeaderBuilder>();
  private List<String> fromParams = new ArrayList<String>();
  private String issuer;
  private String jwks;
  private String jwksUri;
  private ArrayList<ClaimToHeaderBuilder> outputClaimToHeaders = new ArrayList<ClaimToHeaderBuilder>();
  private String outputPayloadToHeader;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(JWTRule instance) {
    instance = (instance != null ? instance : new JWTRule());
    if (instance != null) {
          this.withAudiences(instance.getAudiences());
          this.withForwardOriginalToken(instance.getForwardOriginalToken());
          this.withFromCookies(instance.getFromCookies());
          this.withFromHeaders(instance.getFromHeaders());
          this.withFromParams(instance.getFromParams());
          this.withIssuer(instance.getIssuer());
          this.withJwks(instance.getJwks());
          this.withJwksUri(instance.getJwksUri());
          this.withOutputClaimToHeaders(instance.getOutputClaimToHeaders());
          this.withOutputPayloadToHeader(instance.getOutputPayloadToHeader());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAudiences(int index,String item) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    this.audiences.add(index, item);
    return (A)this;
  }
  
  public A setToAudiences(int index,String item) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    this.audiences.set(index, item); return (A)this;
  }
  
  public A addToAudiences(java.lang.String... items) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    for (String item : items) {this.audiences.add(item);} return (A)this;
  }
  
  public A addAllToAudiences(Collection<String> items) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    for (String item : items) {this.audiences.add(item);} return (A)this;
  }
  
  public A removeFromAudiences(java.lang.String... items) {
    if (this.audiences == null) return (A)this;
    for (String item : items) { this.audiences.remove(item);} return (A)this;
  }
  
  public A removeAllFromAudiences(Collection<String> items) {
    if (this.audiences == null) return (A)this;
    for (String item : items) { this.audiences.remove(item);} return (A)this;
  }
  
  public List<String> getAudiences() {
    return this.audiences;
  }
  
  public String getAudience(int index) {
    return this.audiences.get(index);
  }
  
  public String getFirstAudience() {
    return this.audiences.get(0);
  }
  
  public String getLastAudience() {
    return this.audiences.get(audiences.size() - 1);
  }
  
  public String getMatchingAudience(Predicate<String> predicate) {
      for (String item : audiences) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingAudience(Predicate<String> predicate) {
      for (String item : audiences) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAudiences(List<String> audiences) {
    if (audiences != null) {
        this.audiences = new ArrayList();
        for (String item : audiences) {
          this.addToAudiences(item);
        }
    } else {
      this.audiences = null;
    }
    return (A) this;
  }
  
  public A withAudiences(java.lang.String... audiences) {
    if (this.audiences != null) {
        this.audiences.clear();
        _visitables.remove("audiences");
    }
    if (audiences != null) {
      for (String item : audiences) {
        this.addToAudiences(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAudiences() {
    return this.audiences != null && !this.audiences.isEmpty();
  }
  
  public Boolean getForwardOriginalToken() {
    return this.forwardOriginalToken;
  }
  
  public A withForwardOriginalToken(Boolean forwardOriginalToken) {
    this.forwardOriginalToken = forwardOriginalToken;
    return (A) this;
  }
  
  public boolean hasForwardOriginalToken() {
    return this.forwardOriginalToken != null;
  }
  
  public A addToFromCookies(int index,String item) {
    if (this.fromCookies == null) {this.fromCookies = new ArrayList<String>();}
    this.fromCookies.add(index, item);
    return (A)this;
  }
  
  public A setToFromCookies(int index,String item) {
    if (this.fromCookies == null) {this.fromCookies = new ArrayList<String>();}
    this.fromCookies.set(index, item); return (A)this;
  }
  
  public A addToFromCookies(java.lang.String... items) {
    if (this.fromCookies == null) {this.fromCookies = new ArrayList<String>();}
    for (String item : items) {this.fromCookies.add(item);} return (A)this;
  }
  
  public A addAllToFromCookies(Collection<String> items) {
    if (this.fromCookies == null) {this.fromCookies = new ArrayList<String>();}
    for (String item : items) {this.fromCookies.add(item);} return (A)this;
  }
  
  public A removeFromFromCookies(java.lang.String... items) {
    if (this.fromCookies == null) return (A)this;
    for (String item : items) { this.fromCookies.remove(item);} return (A)this;
  }
  
  public A removeAllFromFromCookies(Collection<String> items) {
    if (this.fromCookies == null) return (A)this;
    for (String item : items) { this.fromCookies.remove(item);} return (A)this;
  }
  
  public List<String> getFromCookies() {
    return this.fromCookies;
  }
  
  public String getFromCooky(int index) {
    return this.fromCookies.get(index);
  }
  
  public String getFirstFromCooky() {
    return this.fromCookies.get(0);
  }
  
  public String getLastFromCooky() {
    return this.fromCookies.get(fromCookies.size() - 1);
  }
  
  public String getMatchingFromCooky(Predicate<String> predicate) {
      for (String item : fromCookies) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingFromCooky(Predicate<String> predicate) {
      for (String item : fromCookies) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFromCookies(List<String> fromCookies) {
    if (fromCookies != null) {
        this.fromCookies = new ArrayList();
        for (String item : fromCookies) {
          this.addToFromCookies(item);
        }
    } else {
      this.fromCookies = null;
    }
    return (A) this;
  }
  
  public A withFromCookies(java.lang.String... fromCookies) {
    if (this.fromCookies != null) {
        this.fromCookies.clear();
        _visitables.remove("fromCookies");
    }
    if (fromCookies != null) {
      for (String item : fromCookies) {
        this.addToFromCookies(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFromCookies() {
    return this.fromCookies != null && !this.fromCookies.isEmpty();
  }
  
  public A addToFromHeaders(int index,JWTHeader item) {
    if (this.fromHeaders == null) {this.fromHeaders = new ArrayList<JWTHeaderBuilder>();}
    JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
    if (index < 0 || index >= fromHeaders.size()) { _visitables.get("fromHeaders").add(builder); fromHeaders.add(builder); } else { _visitables.get("fromHeaders").add(index, builder); fromHeaders.add(index, builder);}
    return (A)this;
  }
  
  public A setToFromHeaders(int index,JWTHeader item) {
    if (this.fromHeaders == null) {this.fromHeaders = new ArrayList<JWTHeaderBuilder>();}
    JWTHeaderBuilder builder = new JWTHeaderBuilder(item);
    if (index < 0 || index >= fromHeaders.size()) { _visitables.get("fromHeaders").add(builder); fromHeaders.add(builder); } else { _visitables.get("fromHeaders").set(index, builder); fromHeaders.set(index, builder);}
    return (A)this;
  }
  
  public A addToFromHeaders(io.fabric8.istio.api.security.v1beta1.JWTHeader... items) {
    if (this.fromHeaders == null) {this.fromHeaders = new ArrayList<JWTHeaderBuilder>();}
    for (JWTHeader item : items) {JWTHeaderBuilder builder = new JWTHeaderBuilder(item);_visitables.get("fromHeaders").add(builder);this.fromHeaders.add(builder);} return (A)this;
  }
  
  public A addAllToFromHeaders(Collection<JWTHeader> items) {
    if (this.fromHeaders == null) {this.fromHeaders = new ArrayList<JWTHeaderBuilder>();}
    for (JWTHeader item : items) {JWTHeaderBuilder builder = new JWTHeaderBuilder(item);_visitables.get("fromHeaders").add(builder);this.fromHeaders.add(builder);} return (A)this;
  }
  
  public A removeFromFromHeaders(io.fabric8.istio.api.security.v1beta1.JWTHeader... items) {
    if (this.fromHeaders == null) return (A)this;
    for (JWTHeader item : items) {JWTHeaderBuilder builder = new JWTHeaderBuilder(item);_visitables.get("fromHeaders").remove(builder); this.fromHeaders.remove(builder);} return (A)this;
  }
  
  public A removeAllFromFromHeaders(Collection<JWTHeader> items) {
    if (this.fromHeaders == null) return (A)this;
    for (JWTHeader item : items) {JWTHeaderBuilder builder = new JWTHeaderBuilder(item);_visitables.get("fromHeaders").remove(builder); this.fromHeaders.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromFromHeaders(Predicate<JWTHeaderBuilder> predicate) {
    if (fromHeaders == null) return (A) this;
    final Iterator<JWTHeaderBuilder> each = fromHeaders.iterator();
    final List visitables = _visitables.get("fromHeaders");
    while (each.hasNext()) {
      JWTHeaderBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<JWTHeader> buildFromHeaders() {
    return this.fromHeaders != null ? build(fromHeaders) : null;
  }
  
  public JWTHeader buildFromHeader(int index) {
    return this.fromHeaders.get(index).build();
  }
  
  public JWTHeader buildFirstFromHeader() {
    return this.fromHeaders.get(0).build();
  }
  
  public JWTHeader buildLastFromHeader() {
    return this.fromHeaders.get(fromHeaders.size() - 1).build();
  }
  
  public JWTHeader buildMatchingFromHeader(Predicate<JWTHeaderBuilder> predicate) {
      for (JWTHeaderBuilder item : fromHeaders) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingFromHeader(Predicate<JWTHeaderBuilder> predicate) {
      for (JWTHeaderBuilder item : fromHeaders) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFromHeaders(List<JWTHeader> fromHeaders) {
    if (this.fromHeaders != null) {
      this._visitables.get("fromHeaders").clear();
    }
    if (fromHeaders != null) {
        this.fromHeaders = new ArrayList();
        for (JWTHeader item : fromHeaders) {
          this.addToFromHeaders(item);
        }
    } else {
      this.fromHeaders = null;
    }
    return (A) this;
  }
  
  public A withFromHeaders(io.fabric8.istio.api.security.v1beta1.JWTHeader... fromHeaders) {
    if (this.fromHeaders != null) {
        this.fromHeaders.clear();
        _visitables.remove("fromHeaders");
    }
    if (fromHeaders != null) {
      for (JWTHeader item : fromHeaders) {
        this.addToFromHeaders(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFromHeaders() {
    return this.fromHeaders != null && !this.fromHeaders.isEmpty();
  }
  
  public A addNewFromHeader(String name,String prefix) {
    return (A)addToFromHeaders(new JWTHeader(name, prefix));
  }
  
  public FromHeadersNested<A> addNewFromHeader() {
    return new FromHeadersNested(-1, null);
  }
  
  public FromHeadersNested<A> addNewFromHeaderLike(JWTHeader item) {
    return new FromHeadersNested(-1, item);
  }
  
  public FromHeadersNested<A> setNewFromHeaderLike(int index,JWTHeader item) {
    return new FromHeadersNested(index, item);
  }
  
  public FromHeadersNested<A> editFromHeader(int index) {
    if (fromHeaders.size() <= index) throw new RuntimeException("Can't edit fromHeaders. Index exceeds size.");
    return setNewFromHeaderLike(index, buildFromHeader(index));
  }
  
  public FromHeadersNested<A> editFirstFromHeader() {
    if (fromHeaders.size() == 0) throw new RuntimeException("Can't edit first fromHeaders. The list is empty.");
    return setNewFromHeaderLike(0, buildFromHeader(0));
  }
  
  public FromHeadersNested<A> editLastFromHeader() {
    int index = fromHeaders.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last fromHeaders. The list is empty.");
    return setNewFromHeaderLike(index, buildFromHeader(index));
  }
  
  public FromHeadersNested<A> editMatchingFromHeader(Predicate<JWTHeaderBuilder> predicate) {
    int index = -1;
    for (int i=0;i<fromHeaders.size();i++) { 
    if (predicate.test(fromHeaders.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching fromHeaders. No match found.");
    return setNewFromHeaderLike(index, buildFromHeader(index));
  }
  
  public A addToFromParams(int index,String item) {
    if (this.fromParams == null) {this.fromParams = new ArrayList<String>();}
    this.fromParams.add(index, item);
    return (A)this;
  }
  
  public A setToFromParams(int index,String item) {
    if (this.fromParams == null) {this.fromParams = new ArrayList<String>();}
    this.fromParams.set(index, item); return (A)this;
  }
  
  public A addToFromParams(java.lang.String... items) {
    if (this.fromParams == null) {this.fromParams = new ArrayList<String>();}
    for (String item : items) {this.fromParams.add(item);} return (A)this;
  }
  
  public A addAllToFromParams(Collection<String> items) {
    if (this.fromParams == null) {this.fromParams = new ArrayList<String>();}
    for (String item : items) {this.fromParams.add(item);} return (A)this;
  }
  
  public A removeFromFromParams(java.lang.String... items) {
    if (this.fromParams == null) return (A)this;
    for (String item : items) { this.fromParams.remove(item);} return (A)this;
  }
  
  public A removeAllFromFromParams(Collection<String> items) {
    if (this.fromParams == null) return (A)this;
    for (String item : items) { this.fromParams.remove(item);} return (A)this;
  }
  
  public List<String> getFromParams() {
    return this.fromParams;
  }
  
  public String getFromParam(int index) {
    return this.fromParams.get(index);
  }
  
  public String getFirstFromParam() {
    return this.fromParams.get(0);
  }
  
  public String getLastFromParam() {
    return this.fromParams.get(fromParams.size() - 1);
  }
  
  public String getMatchingFromParam(Predicate<String> predicate) {
      for (String item : fromParams) {
        if (predicate.test(item)) {
          return item;
        }
      }
      return null;
  }
  
  public boolean hasMatchingFromParam(Predicate<String> predicate) {
      for (String item : fromParams) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withFromParams(List<String> fromParams) {
    if (fromParams != null) {
        this.fromParams = new ArrayList();
        for (String item : fromParams) {
          this.addToFromParams(item);
        }
    } else {
      this.fromParams = null;
    }
    return (A) this;
  }
  
  public A withFromParams(java.lang.String... fromParams) {
    if (this.fromParams != null) {
        this.fromParams.clear();
        _visitables.remove("fromParams");
    }
    if (fromParams != null) {
      for (String item : fromParams) {
        this.addToFromParams(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasFromParams() {
    return this.fromParams != null && !this.fromParams.isEmpty();
  }
  
  public String getIssuer() {
    return this.issuer;
  }
  
  public A withIssuer(String issuer) {
    this.issuer = issuer;
    return (A) this;
  }
  
  public boolean hasIssuer() {
    return this.issuer != null;
  }
  
  public String getJwks() {
    return this.jwks;
  }
  
  public A withJwks(String jwks) {
    this.jwks = jwks;
    return (A) this;
  }
  
  public boolean hasJwks() {
    return this.jwks != null;
  }
  
  public String getJwksUri() {
    return this.jwksUri;
  }
  
  public A withJwksUri(String jwksUri) {
    this.jwksUri = jwksUri;
    return (A) this;
  }
  
  public boolean hasJwksUri() {
    return this.jwksUri != null;
  }
  
  public A addToOutputClaimToHeaders(int index,ClaimToHeader item) {
    if (this.outputClaimToHeaders == null) {this.outputClaimToHeaders = new ArrayList<ClaimToHeaderBuilder>();}
    ClaimToHeaderBuilder builder = new ClaimToHeaderBuilder(item);
    if (index < 0 || index >= outputClaimToHeaders.size()) { _visitables.get("outputClaimToHeaders").add(builder); outputClaimToHeaders.add(builder); } else { _visitables.get("outputClaimToHeaders").add(index, builder); outputClaimToHeaders.add(index, builder);}
    return (A)this;
  }
  
  public A setToOutputClaimToHeaders(int index,ClaimToHeader item) {
    if (this.outputClaimToHeaders == null) {this.outputClaimToHeaders = new ArrayList<ClaimToHeaderBuilder>();}
    ClaimToHeaderBuilder builder = new ClaimToHeaderBuilder(item);
    if (index < 0 || index >= outputClaimToHeaders.size()) { _visitables.get("outputClaimToHeaders").add(builder); outputClaimToHeaders.add(builder); } else { _visitables.get("outputClaimToHeaders").set(index, builder); outputClaimToHeaders.set(index, builder);}
    return (A)this;
  }
  
  public A addToOutputClaimToHeaders(io.fabric8.istio.api.security.v1beta1.ClaimToHeader... items) {
    if (this.outputClaimToHeaders == null) {this.outputClaimToHeaders = new ArrayList<ClaimToHeaderBuilder>();}
    for (ClaimToHeader item : items) {ClaimToHeaderBuilder builder = new ClaimToHeaderBuilder(item);_visitables.get("outputClaimToHeaders").add(builder);this.outputClaimToHeaders.add(builder);} return (A)this;
  }
  
  public A addAllToOutputClaimToHeaders(Collection<ClaimToHeader> items) {
    if (this.outputClaimToHeaders == null) {this.outputClaimToHeaders = new ArrayList<ClaimToHeaderBuilder>();}
    for (ClaimToHeader item : items) {ClaimToHeaderBuilder builder = new ClaimToHeaderBuilder(item);_visitables.get("outputClaimToHeaders").add(builder);this.outputClaimToHeaders.add(builder);} return (A)this;
  }
  
  public A removeFromOutputClaimToHeaders(io.fabric8.istio.api.security.v1beta1.ClaimToHeader... items) {
    if (this.outputClaimToHeaders == null) return (A)this;
    for (ClaimToHeader item : items) {ClaimToHeaderBuilder builder = new ClaimToHeaderBuilder(item);_visitables.get("outputClaimToHeaders").remove(builder); this.outputClaimToHeaders.remove(builder);} return (A)this;
  }
  
  public A removeAllFromOutputClaimToHeaders(Collection<ClaimToHeader> items) {
    if (this.outputClaimToHeaders == null) return (A)this;
    for (ClaimToHeader item : items) {ClaimToHeaderBuilder builder = new ClaimToHeaderBuilder(item);_visitables.get("outputClaimToHeaders").remove(builder); this.outputClaimToHeaders.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromOutputClaimToHeaders(Predicate<ClaimToHeaderBuilder> predicate) {
    if (outputClaimToHeaders == null) return (A) this;
    final Iterator<ClaimToHeaderBuilder> each = outputClaimToHeaders.iterator();
    final List visitables = _visitables.get("outputClaimToHeaders");
    while (each.hasNext()) {
      ClaimToHeaderBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<ClaimToHeader> buildOutputClaimToHeaders() {
    return this.outputClaimToHeaders != null ? build(outputClaimToHeaders) : null;
  }
  
  public ClaimToHeader buildOutputClaimToHeader(int index) {
    return this.outputClaimToHeaders.get(index).build();
  }
  
  public ClaimToHeader buildFirstOutputClaimToHeader() {
    return this.outputClaimToHeaders.get(0).build();
  }
  
  public ClaimToHeader buildLastOutputClaimToHeader() {
    return this.outputClaimToHeaders.get(outputClaimToHeaders.size() - 1).build();
  }
  
  public ClaimToHeader buildMatchingOutputClaimToHeader(Predicate<ClaimToHeaderBuilder> predicate) {
      for (ClaimToHeaderBuilder item : outputClaimToHeaders) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingOutputClaimToHeader(Predicate<ClaimToHeaderBuilder> predicate) {
      for (ClaimToHeaderBuilder item : outputClaimToHeaders) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withOutputClaimToHeaders(List<ClaimToHeader> outputClaimToHeaders) {
    if (this.outputClaimToHeaders != null) {
      this._visitables.get("outputClaimToHeaders").clear();
    }
    if (outputClaimToHeaders != null) {
        this.outputClaimToHeaders = new ArrayList();
        for (ClaimToHeader item : outputClaimToHeaders) {
          this.addToOutputClaimToHeaders(item);
        }
    } else {
      this.outputClaimToHeaders = null;
    }
    return (A) this;
  }
  
  public A withOutputClaimToHeaders(io.fabric8.istio.api.security.v1beta1.ClaimToHeader... outputClaimToHeaders) {
    if (this.outputClaimToHeaders != null) {
        this.outputClaimToHeaders.clear();
        _visitables.remove("outputClaimToHeaders");
    }
    if (outputClaimToHeaders != null) {
      for (ClaimToHeader item : outputClaimToHeaders) {
        this.addToOutputClaimToHeaders(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasOutputClaimToHeaders() {
    return this.outputClaimToHeaders != null && !this.outputClaimToHeaders.isEmpty();
  }
  
  public A addNewOutputClaimToHeader(String claim,String header) {
    return (A)addToOutputClaimToHeaders(new ClaimToHeader(claim, header));
  }
  
  public OutputClaimToHeadersNested<A> addNewOutputClaimToHeader() {
    return new OutputClaimToHeadersNested(-1, null);
  }
  
  public OutputClaimToHeadersNested<A> addNewOutputClaimToHeaderLike(ClaimToHeader item) {
    return new OutputClaimToHeadersNested(-1, item);
  }
  
  public OutputClaimToHeadersNested<A> setNewOutputClaimToHeaderLike(int index,ClaimToHeader item) {
    return new OutputClaimToHeadersNested(index, item);
  }
  
  public OutputClaimToHeadersNested<A> editOutputClaimToHeader(int index) {
    if (outputClaimToHeaders.size() <= index) throw new RuntimeException("Can't edit outputClaimToHeaders. Index exceeds size.");
    return setNewOutputClaimToHeaderLike(index, buildOutputClaimToHeader(index));
  }
  
  public OutputClaimToHeadersNested<A> editFirstOutputClaimToHeader() {
    if (outputClaimToHeaders.size() == 0) throw new RuntimeException("Can't edit first outputClaimToHeaders. The list is empty.");
    return setNewOutputClaimToHeaderLike(0, buildOutputClaimToHeader(0));
  }
  
  public OutputClaimToHeadersNested<A> editLastOutputClaimToHeader() {
    int index = outputClaimToHeaders.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last outputClaimToHeaders. The list is empty.");
    return setNewOutputClaimToHeaderLike(index, buildOutputClaimToHeader(index));
  }
  
  public OutputClaimToHeadersNested<A> editMatchingOutputClaimToHeader(Predicate<ClaimToHeaderBuilder> predicate) {
    int index = -1;
    for (int i=0;i<outputClaimToHeaders.size();i++) { 
    if (predicate.test(outputClaimToHeaders.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching outputClaimToHeaders. No match found.");
    return setNewOutputClaimToHeaderLike(index, buildOutputClaimToHeader(index));
  }
  
  public String getOutputPayloadToHeader() {
    return this.outputPayloadToHeader;
  }
  
  public A withOutputPayloadToHeader(String outputPayloadToHeader) {
    this.outputPayloadToHeader = outputPayloadToHeader;
    return (A) this;
  }
  
  public boolean hasOutputPayloadToHeader() {
    return this.outputPayloadToHeader != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JWTRuleFluent that = (JWTRuleFluent) o;
    if (!java.util.Objects.equals(audiences, that.audiences)) return false;
    if (!java.util.Objects.equals(forwardOriginalToken, that.forwardOriginalToken)) return false;
    if (!java.util.Objects.equals(fromCookies, that.fromCookies)) return false;
    if (!java.util.Objects.equals(fromHeaders, that.fromHeaders)) return false;
    if (!java.util.Objects.equals(fromParams, that.fromParams)) return false;
    if (!java.util.Objects.equals(issuer, that.issuer)) return false;
    if (!java.util.Objects.equals(jwks, that.jwks)) return false;
    if (!java.util.Objects.equals(jwksUri, that.jwksUri)) return false;
    if (!java.util.Objects.equals(outputClaimToHeaders, that.outputClaimToHeaders)) return false;
    if (!java.util.Objects.equals(outputPayloadToHeader, that.outputPayloadToHeader)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(audiences,  forwardOriginalToken,  fromCookies,  fromHeaders,  fromParams,  issuer,  jwks,  jwksUri,  outputClaimToHeaders,  outputPayloadToHeader,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (audiences != null && !audiences.isEmpty()) { sb.append("audiences:"); sb.append(audiences + ","); }
    if (forwardOriginalToken != null) { sb.append("forwardOriginalToken:"); sb.append(forwardOriginalToken + ","); }
    if (fromCookies != null && !fromCookies.isEmpty()) { sb.append("fromCookies:"); sb.append(fromCookies + ","); }
    if (fromHeaders != null && !fromHeaders.isEmpty()) { sb.append("fromHeaders:"); sb.append(fromHeaders + ","); }
    if (fromParams != null && !fromParams.isEmpty()) { sb.append("fromParams:"); sb.append(fromParams + ","); }
    if (issuer != null) { sb.append("issuer:"); sb.append(issuer + ","); }
    if (jwks != null) { sb.append("jwks:"); sb.append(jwks + ","); }
    if (jwksUri != null) { sb.append("jwksUri:"); sb.append(jwksUri + ","); }
    if (outputClaimToHeaders != null && !outputClaimToHeaders.isEmpty()) { sb.append("outputClaimToHeaders:"); sb.append(outputClaimToHeaders + ","); }
    if (outputPayloadToHeader != null) { sb.append("outputPayloadToHeader:"); sb.append(outputPayloadToHeader + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withForwardOriginalToken() {
    return withForwardOriginalToken(true);
  }
  public class FromHeadersNested<N> extends JWTHeaderFluent<FromHeadersNested<N>> implements Nested<N>{
    FromHeadersNested(int index,JWTHeader item) {
      this.index = index;
      this.builder = new JWTHeaderBuilder(this, item);
    }
    JWTHeaderBuilder builder;
    int index;
    
    public N and() {
      return (N) JWTRuleFluent.this.setToFromHeaders(index,builder.build());
    }
    
    public N endFromHeader() {
      return and();
    }
    
  
  }
  public class OutputClaimToHeadersNested<N> extends ClaimToHeaderFluent<OutputClaimToHeadersNested<N>> implements Nested<N>{
    OutputClaimToHeadersNested(int index,ClaimToHeader item) {
      this.index = index;
      this.builder = new ClaimToHeaderBuilder(this, item);
    }
    ClaimToHeaderBuilder builder;
    int index;
    
    public N and() {
      return (N) JWTRuleFluent.this.setToOutputClaimToHeaders(index,builder.build());
    }
    
    public N endOutputClaimToHeader() {
      return and();
    }
    
  
  }

}