package io.fabric8.istio.api.networking.v1beta1;

import java.lang.Integer;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class TrafficPolicyTunnelSettingsFluent<A extends TrafficPolicyTunnelSettingsFluent<A>> extends BaseFluent<A>{
  public TrafficPolicyTunnelSettingsFluent() {
  }
  
  public TrafficPolicyTunnelSettingsFluent(TrafficPolicyTunnelSettings instance) {
    this.copyInstance(instance);
  }
  private String protocol;
  private String targetHost;
  private Integer targetPort;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(TrafficPolicyTunnelSettings instance) {
    instance = (instance != null ? instance : new TrafficPolicyTunnelSettings());
    if (instance != null) {
          this.withProtocol(instance.getProtocol());
          this.withTargetHost(instance.getTargetHost());
          this.withTargetPort(instance.getTargetPort());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getProtocol() {
    return this.protocol;
  }
  
  public A withProtocol(String protocol) {
    this.protocol = protocol;
    return (A) this;
  }
  
  public boolean hasProtocol() {
    return this.protocol != null;
  }
  
  public String getTargetHost() {
    return this.targetHost;
  }
  
  public A withTargetHost(String targetHost) {
    this.targetHost = targetHost;
    return (A) this;
  }
  
  public boolean hasTargetHost() {
    return this.targetHost != null;
  }
  
  public Integer getTargetPort() {
    return this.targetPort;
  }
  
  public A withTargetPort(Integer targetPort) {
    this.targetPort = targetPort;
    return (A) this;
  }
  
  public boolean hasTargetPort() {
    return this.targetPort != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TrafficPolicyTunnelSettingsFluent that = (TrafficPolicyTunnelSettingsFluent) o;
    if (!java.util.Objects.equals(protocol, that.protocol)) return false;
    if (!java.util.Objects.equals(targetHost, that.targetHost)) return false;
    if (!java.util.Objects.equals(targetPort, that.targetPort)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(protocol,  targetHost,  targetPort,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (protocol != null) { sb.append("protocol:"); sb.append(protocol + ","); }
    if (targetHost != null) { sb.append("targetHost:"); sb.append(targetHost + ","); }
    if (targetPort != null) { sb.append("targetPort:"); sb.append(targetPort + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  

}