package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TrafficPolicyTunnelSettingsBuilder extends TrafficPolicyTunnelSettingsFluent<TrafficPolicyTunnelSettingsBuilder> implements VisitableBuilder<TrafficPolicyTunnelSettings,TrafficPolicyTunnelSettingsBuilder>{
  public TrafficPolicyTunnelSettingsBuilder() {
    this(new TrafficPolicyTunnelSettings());
  }
  
  public TrafficPolicyTunnelSettingsBuilder(TrafficPolicyTunnelSettingsFluent<?> fluent) {
    this(fluent, new TrafficPolicyTunnelSettings());
  }
  
  public TrafficPolicyTunnelSettingsBuilder(TrafficPolicyTunnelSettingsFluent<?> fluent,TrafficPolicyTunnelSettings instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TrafficPolicyTunnelSettingsBuilder(TrafficPolicyTunnelSettings instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TrafficPolicyTunnelSettingsFluent<?> fluent;
  
  public TrafficPolicyTunnelSettings build() {
    TrafficPolicyTunnelSettings buildable = new TrafficPolicyTunnelSettings(fluent.getProtocol(),fluent.getTargetHost(),fluent.getTargetPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}