package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class TrafficPolicyBuilder extends TrafficPolicyFluent<TrafficPolicyBuilder> implements VisitableBuilder<TrafficPolicy,TrafficPolicyBuilder>{
  public TrafficPolicyBuilder() {
    this(new TrafficPolicy());
  }
  
  public TrafficPolicyBuilder(TrafficPolicyFluent<?> fluent) {
    this(fluent, new TrafficPolicy());
  }
  
  public TrafficPolicyBuilder(TrafficPolicyFluent<?> fluent,TrafficPolicy instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public TrafficPolicyBuilder(TrafficPolicy instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  TrafficPolicyFluent<?> fluent;
  
  public TrafficPolicy build() {
    TrafficPolicy buildable = new TrafficPolicy(fluent.buildConnectionPool(),fluent.buildLoadBalancer(),fluent.buildOutlierDetection(),fluent.buildPortLevelSettings(),fluent.buildProxyProtocol(),fluent.buildTls(),fluent.buildTunnel());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}