package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SidecarSpecFluent<A extends SidecarSpecFluent<A>> extends BaseFluent<A>{
  public SidecarSpecFluent() {
  }
  
  public SidecarSpecFluent(SidecarSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<IstioEgressListenerBuilder> egress = new ArrayList<IstioEgressListenerBuilder>();
  private ConnectionPoolSettingsBuilder inboundConnectionPool;
  private ArrayList<IstioIngressListenerBuilder> ingress = new ArrayList<IstioIngressListenerBuilder>();
  private OutboundTrafficPolicyBuilder outboundTrafficPolicy;
  private WorkloadSelectorBuilder workloadSelector;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SidecarSpec instance) {
    instance = (instance != null ? instance : new SidecarSpec());
    if (instance != null) {
          this.withEgress(instance.getEgress());
          this.withInboundConnectionPool(instance.getInboundConnectionPool());
          this.withIngress(instance.getIngress());
          this.withOutboundTrafficPolicy(instance.getOutboundTrafficPolicy());
          this.withWorkloadSelector(instance.getWorkloadSelector());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToEgress(int index,IstioEgressListener item) {
    if (this.egress == null) {this.egress = new ArrayList<IstioEgressListenerBuilder>();}
    IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);
    if (index < 0 || index >= egress.size()) { _visitables.get("egress").add(builder); egress.add(builder); } else { _visitables.get("egress").add(index, builder); egress.add(index, builder);}
    return (A)this;
  }
  
  public A setToEgress(int index,IstioEgressListener item) {
    if (this.egress == null) {this.egress = new ArrayList<IstioEgressListenerBuilder>();}
    IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);
    if (index < 0 || index >= egress.size()) { _visitables.get("egress").add(builder); egress.add(builder); } else { _visitables.get("egress").set(index, builder); egress.set(index, builder);}
    return (A)this;
  }
  
  public A addToEgress(io.fabric8.istio.api.networking.v1beta1.IstioEgressListener... items) {
    if (this.egress == null) {this.egress = new ArrayList<IstioEgressListenerBuilder>();}
    for (IstioEgressListener item : items) {IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
  }
  
  public A addAllToEgress(Collection<IstioEgressListener> items) {
    if (this.egress == null) {this.egress = new ArrayList<IstioEgressListenerBuilder>();}
    for (IstioEgressListener item : items) {IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);_visitables.get("egress").add(builder);this.egress.add(builder);} return (A)this;
  }
  
  public A removeFromEgress(io.fabric8.istio.api.networking.v1beta1.IstioEgressListener... items) {
    if (this.egress == null) return (A)this;
    for (IstioEgressListener item : items) {IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);_visitables.get("egress").remove(builder); this.egress.remove(builder);} return (A)this;
  }
  
  public A removeAllFromEgress(Collection<IstioEgressListener> items) {
    if (this.egress == null) return (A)this;
    for (IstioEgressListener item : items) {IstioEgressListenerBuilder builder = new IstioEgressListenerBuilder(item);_visitables.get("egress").remove(builder); this.egress.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromEgress(Predicate<IstioEgressListenerBuilder> predicate) {
    if (egress == null) return (A) this;
    final Iterator<IstioEgressListenerBuilder> each = egress.iterator();
    final List visitables = _visitables.get("egress");
    while (each.hasNext()) {
      IstioEgressListenerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<IstioEgressListener> buildEgress() {
    return this.egress != null ? build(egress) : null;
  }
  
  public IstioEgressListener buildEgress(int index) {
    return this.egress.get(index).build();
  }
  
  public IstioEgressListener buildFirstEgress() {
    return this.egress.get(0).build();
  }
  
  public IstioEgressListener buildLastEgress() {
    return this.egress.get(egress.size() - 1).build();
  }
  
  public IstioEgressListener buildMatchingEgress(Predicate<IstioEgressListenerBuilder> predicate) {
      for (IstioEgressListenerBuilder item : egress) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingEgress(Predicate<IstioEgressListenerBuilder> predicate) {
      for (IstioEgressListenerBuilder item : egress) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withEgress(List<IstioEgressListener> egress) {
    if (this.egress != null) {
      this._visitables.get("egress").clear();
    }
    if (egress != null) {
        this.egress = new ArrayList();
        for (IstioEgressListener item : egress) {
          this.addToEgress(item);
        }
    } else {
      this.egress = null;
    }
    return (A) this;
  }
  
  public A withEgress(io.fabric8.istio.api.networking.v1beta1.IstioEgressListener... egress) {
    if (this.egress != null) {
        this.egress.clear();
        _visitables.remove("egress");
    }
    if (egress != null) {
      for (IstioEgressListener item : egress) {
        this.addToEgress(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasEgress() {
    return this.egress != null && !this.egress.isEmpty();
  }
  
  public EgressNested<A> addNewEgress() {
    return new EgressNested(-1, null);
  }
  
  public EgressNested<A> addNewEgressLike(IstioEgressListener item) {
    return new EgressNested(-1, item);
  }
  
  public EgressNested<A> setNewEgressLike(int index,IstioEgressListener item) {
    return new EgressNested(index, item);
  }
  
  public EgressNested<A> editEgress(int index) {
    if (egress.size() <= index) throw new RuntimeException("Can't edit egress. Index exceeds size.");
    return setNewEgressLike(index, buildEgress(index));
  }
  
  public EgressNested<A> editFirstEgress() {
    if (egress.size() == 0) throw new RuntimeException("Can't edit first egress. The list is empty.");
    return setNewEgressLike(0, buildEgress(0));
  }
  
  public EgressNested<A> editLastEgress() {
    int index = egress.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last egress. The list is empty.");
    return setNewEgressLike(index, buildEgress(index));
  }
  
  public EgressNested<A> editMatchingEgress(Predicate<IstioEgressListenerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<egress.size();i++) { 
    if (predicate.test(egress.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching egress. No match found.");
    return setNewEgressLike(index, buildEgress(index));
  }
  
  public ConnectionPoolSettings buildInboundConnectionPool() {
    return this.inboundConnectionPool != null ? this.inboundConnectionPool.build() : null;
  }
  
  public A withInboundConnectionPool(ConnectionPoolSettings inboundConnectionPool) {
    this._visitables.remove("inboundConnectionPool");
    if (inboundConnectionPool != null) {
        this.inboundConnectionPool = new ConnectionPoolSettingsBuilder(inboundConnectionPool);
        this._visitables.get("inboundConnectionPool").add(this.inboundConnectionPool);
    } else {
        this.inboundConnectionPool = null;
        this._visitables.get("inboundConnectionPool").remove(this.inboundConnectionPool);
    }
    return (A) this;
  }
  
  public boolean hasInboundConnectionPool() {
    return this.inboundConnectionPool != null;
  }
  
  public InboundConnectionPoolNested<A> withNewInboundConnectionPool() {
    return new InboundConnectionPoolNested(null);
  }
  
  public InboundConnectionPoolNested<A> withNewInboundConnectionPoolLike(ConnectionPoolSettings item) {
    return new InboundConnectionPoolNested(item);
  }
  
  public InboundConnectionPoolNested<A> editInboundConnectionPool() {
    return withNewInboundConnectionPoolLike(java.util.Optional.ofNullable(buildInboundConnectionPool()).orElse(null));
  }
  
  public InboundConnectionPoolNested<A> editOrNewInboundConnectionPool() {
    return withNewInboundConnectionPoolLike(java.util.Optional.ofNullable(buildInboundConnectionPool()).orElse(new ConnectionPoolSettingsBuilder().build()));
  }
  
  public InboundConnectionPoolNested<A> editOrNewInboundConnectionPoolLike(ConnectionPoolSettings item) {
    return withNewInboundConnectionPoolLike(java.util.Optional.ofNullable(buildInboundConnectionPool()).orElse(item));
  }
  
  public A addToIngress(int index,IstioIngressListener item) {
    if (this.ingress == null) {this.ingress = new ArrayList<IstioIngressListenerBuilder>();}
    IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);
    if (index < 0 || index >= ingress.size()) { _visitables.get("ingress").add(builder); ingress.add(builder); } else { _visitables.get("ingress").add(index, builder); ingress.add(index, builder);}
    return (A)this;
  }
  
  public A setToIngress(int index,IstioIngressListener item) {
    if (this.ingress == null) {this.ingress = new ArrayList<IstioIngressListenerBuilder>();}
    IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);
    if (index < 0 || index >= ingress.size()) { _visitables.get("ingress").add(builder); ingress.add(builder); } else { _visitables.get("ingress").set(index, builder); ingress.set(index, builder);}
    return (A)this;
  }
  
  public A addToIngress(io.fabric8.istio.api.networking.v1beta1.IstioIngressListener... items) {
    if (this.ingress == null) {this.ingress = new ArrayList<IstioIngressListenerBuilder>();}
    for (IstioIngressListener item : items) {IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  
  public A addAllToIngress(Collection<IstioIngressListener> items) {
    if (this.ingress == null) {this.ingress = new ArrayList<IstioIngressListenerBuilder>();}
    for (IstioIngressListener item : items) {IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);_visitables.get("ingress").add(builder);this.ingress.add(builder);} return (A)this;
  }
  
  public A removeFromIngress(io.fabric8.istio.api.networking.v1beta1.IstioIngressListener... items) {
    if (this.ingress == null) return (A)this;
    for (IstioIngressListener item : items) {IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);_visitables.get("ingress").remove(builder); this.ingress.remove(builder);} return (A)this;
  }
  
  public A removeAllFromIngress(Collection<IstioIngressListener> items) {
    if (this.ingress == null) return (A)this;
    for (IstioIngressListener item : items) {IstioIngressListenerBuilder builder = new IstioIngressListenerBuilder(item);_visitables.get("ingress").remove(builder); this.ingress.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromIngress(Predicate<IstioIngressListenerBuilder> predicate) {
    if (ingress == null) return (A) this;
    final Iterator<IstioIngressListenerBuilder> each = ingress.iterator();
    final List visitables = _visitables.get("ingress");
    while (each.hasNext()) {
      IstioIngressListenerBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<IstioIngressListener> buildIngress() {
    return this.ingress != null ? build(ingress) : null;
  }
  
  public IstioIngressListener buildIngress(int index) {
    return this.ingress.get(index).build();
  }
  
  public IstioIngressListener buildFirstIngress() {
    return this.ingress.get(0).build();
  }
  
  public IstioIngressListener buildLastIngress() {
    return this.ingress.get(ingress.size() - 1).build();
  }
  
  public IstioIngressListener buildMatchingIngress(Predicate<IstioIngressListenerBuilder> predicate) {
      for (IstioIngressListenerBuilder item : ingress) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingIngress(Predicate<IstioIngressListenerBuilder> predicate) {
      for (IstioIngressListenerBuilder item : ingress) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withIngress(List<IstioIngressListener> ingress) {
    if (this.ingress != null) {
      this._visitables.get("ingress").clear();
    }
    if (ingress != null) {
        this.ingress = new ArrayList();
        for (IstioIngressListener item : ingress) {
          this.addToIngress(item);
        }
    } else {
      this.ingress = null;
    }
    return (A) this;
  }
  
  public A withIngress(io.fabric8.istio.api.networking.v1beta1.IstioIngressListener... ingress) {
    if (this.ingress != null) {
        this.ingress.clear();
        _visitables.remove("ingress");
    }
    if (ingress != null) {
      for (IstioIngressListener item : ingress) {
        this.addToIngress(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasIngress() {
    return this.ingress != null && !this.ingress.isEmpty();
  }
  
  public IngressNested<A> addNewIngress() {
    return new IngressNested(-1, null);
  }
  
  public IngressNested<A> addNewIngressLike(IstioIngressListener item) {
    return new IngressNested(-1, item);
  }
  
  public IngressNested<A> setNewIngressLike(int index,IstioIngressListener item) {
    return new IngressNested(index, item);
  }
  
  public IngressNested<A> editIngress(int index) {
    if (ingress.size() <= index) throw new RuntimeException("Can't edit ingress. Index exceeds size.");
    return setNewIngressLike(index, buildIngress(index));
  }
  
  public IngressNested<A> editFirstIngress() {
    if (ingress.size() == 0) throw new RuntimeException("Can't edit first ingress. The list is empty.");
    return setNewIngressLike(0, buildIngress(0));
  }
  
  public IngressNested<A> editLastIngress() {
    int index = ingress.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last ingress. The list is empty.");
    return setNewIngressLike(index, buildIngress(index));
  }
  
  public IngressNested<A> editMatchingIngress(Predicate<IstioIngressListenerBuilder> predicate) {
    int index = -1;
    for (int i=0;i<ingress.size();i++) { 
    if (predicate.test(ingress.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching ingress. No match found.");
    return setNewIngressLike(index, buildIngress(index));
  }
  
  public OutboundTrafficPolicy buildOutboundTrafficPolicy() {
    return this.outboundTrafficPolicy != null ? this.outboundTrafficPolicy.build() : null;
  }
  
  public A withOutboundTrafficPolicy(OutboundTrafficPolicy outboundTrafficPolicy) {
    this._visitables.remove("outboundTrafficPolicy");
    if (outboundTrafficPolicy != null) {
        this.outboundTrafficPolicy = new OutboundTrafficPolicyBuilder(outboundTrafficPolicy);
        this._visitables.get("outboundTrafficPolicy").add(this.outboundTrafficPolicy);
    } else {
        this.outboundTrafficPolicy = null;
        this._visitables.get("outboundTrafficPolicy").remove(this.outboundTrafficPolicy);
    }
    return (A) this;
  }
  
  public boolean hasOutboundTrafficPolicy() {
    return this.outboundTrafficPolicy != null;
  }
  
  public OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicy() {
    return new OutboundTrafficPolicyNested(null);
  }
  
  public OutboundTrafficPolicyNested<A> withNewOutboundTrafficPolicyLike(OutboundTrafficPolicy item) {
    return new OutboundTrafficPolicyNested(item);
  }
  
  public OutboundTrafficPolicyNested<A> editOutboundTrafficPolicy() {
    return withNewOutboundTrafficPolicyLike(java.util.Optional.ofNullable(buildOutboundTrafficPolicy()).orElse(null));
  }
  
  public OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicy() {
    return withNewOutboundTrafficPolicyLike(java.util.Optional.ofNullable(buildOutboundTrafficPolicy()).orElse(new OutboundTrafficPolicyBuilder().build()));
  }
  
  public OutboundTrafficPolicyNested<A> editOrNewOutboundTrafficPolicyLike(OutboundTrafficPolicy item) {
    return withNewOutboundTrafficPolicyLike(java.util.Optional.ofNullable(buildOutboundTrafficPolicy()).orElse(item));
  }
  
  public WorkloadSelector buildWorkloadSelector() {
    return this.workloadSelector != null ? this.workloadSelector.build() : null;
  }
  
  public A withWorkloadSelector(WorkloadSelector workloadSelector) {
    this._visitables.remove("workloadSelector");
    if (workloadSelector != null) {
        this.workloadSelector = new WorkloadSelectorBuilder(workloadSelector);
        this._visitables.get("workloadSelector").add(this.workloadSelector);
    } else {
        this.workloadSelector = null;
        this._visitables.get("workloadSelector").remove(this.workloadSelector);
    }
    return (A) this;
  }
  
  public boolean hasWorkloadSelector() {
    return this.workloadSelector != null;
  }
  
  public WorkloadSelectorNested<A> withNewWorkloadSelector() {
    return new WorkloadSelectorNested(null);
  }
  
  public WorkloadSelectorNested<A> withNewWorkloadSelectorLike(WorkloadSelector item) {
    return new WorkloadSelectorNested(item);
  }
  
  public WorkloadSelectorNested<A> editWorkloadSelector() {
    return withNewWorkloadSelectorLike(java.util.Optional.ofNullable(buildWorkloadSelector()).orElse(null));
  }
  
  public WorkloadSelectorNested<A> editOrNewWorkloadSelector() {
    return withNewWorkloadSelectorLike(java.util.Optional.ofNullable(buildWorkloadSelector()).orElse(new WorkloadSelectorBuilder().build()));
  }
  
  public WorkloadSelectorNested<A> editOrNewWorkloadSelectorLike(WorkloadSelector item) {
    return withNewWorkloadSelectorLike(java.util.Optional.ofNullable(buildWorkloadSelector()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SidecarSpecFluent that = (SidecarSpecFluent) o;
    if (!java.util.Objects.equals(egress, that.egress)) return false;
    if (!java.util.Objects.equals(inboundConnectionPool, that.inboundConnectionPool)) return false;
    if (!java.util.Objects.equals(ingress, that.ingress)) return false;
    if (!java.util.Objects.equals(outboundTrafficPolicy, that.outboundTrafficPolicy)) return false;
    if (!java.util.Objects.equals(workloadSelector, that.workloadSelector)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(egress,  inboundConnectionPool,  ingress,  outboundTrafficPolicy,  workloadSelector,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (egress != null && !egress.isEmpty()) { sb.append("egress:"); sb.append(egress + ","); }
    if (inboundConnectionPool != null) { sb.append("inboundConnectionPool:"); sb.append(inboundConnectionPool + ","); }
    if (ingress != null && !ingress.isEmpty()) { sb.append("ingress:"); sb.append(ingress + ","); }
    if (outboundTrafficPolicy != null) { sb.append("outboundTrafficPolicy:"); sb.append(outboundTrafficPolicy + ","); }
    if (workloadSelector != null) { sb.append("workloadSelector:"); sb.append(workloadSelector + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class EgressNested<N> extends IstioEgressListenerFluent<EgressNested<N>> implements Nested<N>{
    EgressNested(int index,IstioEgressListener item) {
      this.index = index;
      this.builder = new IstioEgressListenerBuilder(this, item);
    }
    IstioEgressListenerBuilder builder;
    int index;
    
    public N and() {
      return (N) SidecarSpecFluent.this.setToEgress(index,builder.build());
    }
    
    public N endEgress() {
      return and();
    }
    
  
  }
  public class InboundConnectionPoolNested<N> extends ConnectionPoolSettingsFluent<InboundConnectionPoolNested<N>> implements Nested<N>{
    InboundConnectionPoolNested(ConnectionPoolSettings item) {
      this.builder = new ConnectionPoolSettingsBuilder(this, item);
    }
    ConnectionPoolSettingsBuilder builder;
    
    public N and() {
      return (N) SidecarSpecFluent.this.withInboundConnectionPool(builder.build());
    }
    
    public N endInboundConnectionPool() {
      return and();
    }
    
  
  }
  public class IngressNested<N> extends IstioIngressListenerFluent<IngressNested<N>> implements Nested<N>{
    IngressNested(int index,IstioIngressListener item) {
      this.index = index;
      this.builder = new IstioIngressListenerBuilder(this, item);
    }
    IstioIngressListenerBuilder builder;
    int index;
    
    public N and() {
      return (N) SidecarSpecFluent.this.setToIngress(index,builder.build());
    }
    
    public N endIngress() {
      return and();
    }
    
  
  }
  public class OutboundTrafficPolicyNested<N> extends OutboundTrafficPolicyFluent<OutboundTrafficPolicyNested<N>> implements Nested<N>{
    OutboundTrafficPolicyNested(OutboundTrafficPolicy item) {
      this.builder = new OutboundTrafficPolicyBuilder(this, item);
    }
    OutboundTrafficPolicyBuilder builder;
    
    public N and() {
      return (N) SidecarSpecFluent.this.withOutboundTrafficPolicy(builder.build());
    }
    
    public N endOutboundTrafficPolicy() {
      return and();
    }
    
  
  }
  public class WorkloadSelectorNested<N> extends WorkloadSelectorFluent<WorkloadSelectorNested<N>> implements Nested<N>{
    WorkloadSelectorNested(WorkloadSelector item) {
      this.builder = new WorkloadSelectorBuilder(this, item);
    }
    WorkloadSelectorBuilder builder;
    
    public N and() {
      return (N) SidecarSpecFluent.this.withWorkloadSelector(builder.build());
    }
    
    public N endWorkloadSelector() {
      return and();
    }
    
  
  }

}