package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class SidecarPortBuilder extends SidecarPortFluent<SidecarPortBuilder> implements VisitableBuilder<SidecarPort,SidecarPortBuilder>{
  public SidecarPortBuilder() {
    this(new SidecarPort());
  }
  
  public SidecarPortBuilder(SidecarPortFluent<?> fluent) {
    this(fluent, new SidecarPort());
  }
  
  public SidecarPortBuilder(SidecarPortFluent<?> fluent,SidecarPort instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public SidecarPortBuilder(SidecarPort instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  SidecarPortFluent<?> fluent;
  
  public SidecarPort build() {
    SidecarPort buildable = new SidecarPort(fluent.getName(),fluent.getNumber(),fluent.getProtocol(),fluent.getTargetPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}