package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ServicePortBuilder extends ServicePortFluent<ServicePortBuilder> implements VisitableBuilder<ServicePort,ServicePortBuilder>{
  public ServicePortBuilder() {
    this(new ServicePort());
  }
  
  public ServicePortBuilder(ServicePortFluent<?> fluent) {
    this(fluent, new ServicePort());
  }
  
  public ServicePortBuilder(ServicePortFluent<?> fluent,ServicePort instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ServicePortBuilder(ServicePort instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ServicePortFluent<?> fluent;
  
  public ServicePort build() {
    ServicePort buildable = new ServicePort(fluent.getName(),fluent.getNumber(),fluent.getProtocol(),fluent.getTargetPort());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}