package io.fabric8.istio.api.networking.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelector;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorFluent;
import java.util.Map;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorBuilder;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ProxyConfigSpecFluent<A extends ProxyConfigSpecFluent<A>> extends BaseFluent<A>{
  public ProxyConfigSpecFluent() {
  }
  
  public ProxyConfigSpecFluent(ProxyConfigSpec instance) {
    this.copyInstance(instance);
  }
  private Integer concurrency;
  private Map<String,String> environmentVariables;
  private ProxyImageBuilder image;
  private WorkloadSelectorBuilder selector;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ProxyConfigSpec instance) {
    instance = (instance != null ? instance : new ProxyConfigSpec());
    if (instance != null) {
          this.withConcurrency(instance.getConcurrency());
          this.withEnvironmentVariables(instance.getEnvironmentVariables());
          this.withImage(instance.getImage());
          this.withSelector(instance.getSelector());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getConcurrency() {
    return this.concurrency;
  }
  
  public A withConcurrency(Integer concurrency) {
    this.concurrency = concurrency;
    return (A) this;
  }
  
  public boolean hasConcurrency() {
    return this.concurrency != null;
  }
  
  public A addToEnvironmentVariables(String key,String value) {
    if(this.environmentVariables == null && key != null && value != null) { this.environmentVariables = new LinkedHashMap(); }
    if(key != null && value != null) {this.environmentVariables.put(key, value);} return (A)this;
  }
  
  public A addToEnvironmentVariables(Map<String,String> map) {
    if(this.environmentVariables == null && map != null) { this.environmentVariables = new LinkedHashMap(); }
    if(map != null) { this.environmentVariables.putAll(map);} return (A)this;
  }
  
  public A removeFromEnvironmentVariables(String key) {
    if(this.environmentVariables == null) { return (A) this; }
    if(key != null && this.environmentVariables != null) {this.environmentVariables.remove(key);} return (A)this;
  }
  
  public A removeFromEnvironmentVariables(Map<String,String> map) {
    if(this.environmentVariables == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.environmentVariables != null){this.environmentVariables.remove(key);}}} return (A)this;
  }
  
  public Map<String,String> getEnvironmentVariables() {
    return this.environmentVariables;
  }
  
  public <K,V>A withEnvironmentVariables(Map<String,String> environmentVariables) {
    if (environmentVariables == null) {
      this.environmentVariables = null;
    } else {
      this.environmentVariables = new LinkedHashMap(environmentVariables);
    }
    return (A) this;
  }
  
  public boolean hasEnvironmentVariables() {
    return this.environmentVariables != null;
  }
  
  public ProxyImage buildImage() {
    return this.image != null ? this.image.build() : null;
  }
  
  public A withImage(ProxyImage image) {
    this._visitables.remove("image");
    if (image != null) {
        this.image = new ProxyImageBuilder(image);
        this._visitables.get("image").add(this.image);
    } else {
        this.image = null;
        this._visitables.get("image").remove(this.image);
    }
    return (A) this;
  }
  
  public boolean hasImage() {
    return this.image != null;
  }
  
  public A withNewImage(String imageType) {
    return (A)withImage(new ProxyImage(imageType));
  }
  
  public ImageNested<A> withNewImage() {
    return new ImageNested(null);
  }
  
  public ImageNested<A> withNewImageLike(ProxyImage item) {
    return new ImageNested(item);
  }
  
  public ImageNested<A> editImage() {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(null));
  }
  
  public ImageNested<A> editOrNewImage() {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(new ProxyImageBuilder().build()));
  }
  
  public ImageNested<A> editOrNewImageLike(ProxyImage item) {
    return withNewImageLike(java.util.Optional.ofNullable(buildImage()).orElse(item));
  }
  
  public WorkloadSelector buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(WorkloadSelector selector) {
    this._visitables.remove("selector");
    if (selector != null) {
        this.selector = new WorkloadSelectorBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(WorkloadSelector item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editTypeSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new WorkloadSelectorBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(WorkloadSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ProxyConfigSpecFluent that = (ProxyConfigSpecFluent) o;
    if (!java.util.Objects.equals(concurrency, that.concurrency)) return false;
    if (!java.util.Objects.equals(environmentVariables, that.environmentVariables)) return false;
    if (!java.util.Objects.equals(image, that.image)) return false;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(concurrency,  environmentVariables,  image,  selector,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (concurrency != null) { sb.append("concurrency:"); sb.append(concurrency + ","); }
    if (environmentVariables != null && !environmentVariables.isEmpty()) { sb.append("environmentVariables:"); sb.append(environmentVariables + ","); }
    if (image != null) { sb.append("image:"); sb.append(image + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ImageNested<N> extends ProxyImageFluent<ImageNested<N>> implements Nested<N>{
    ImageNested(ProxyImage item) {
      this.builder = new ProxyImageBuilder(this, item);
    }
    ProxyImageBuilder builder;
    
    public N and() {
      return (N) ProxyConfigSpecFluent.this.withImage(builder.build());
    }
    
    public N endImage() {
      return and();
    }
    
  
  }
  public class SelectorNested<N> extends WorkloadSelectorFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(WorkloadSelector item) {
      this.builder = new WorkloadSelectorBuilder(this, item);
    }
    WorkloadSelectorBuilder builder;
    
    public N and() {
      return (N) ProxyConfigSpecFluent.this.withSelector(builder.build());
    }
    
    public N endTypeSelector() {
      return and();
    }
    
  
  }

}