package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ProxyConfigSpecBuilder extends ProxyConfigSpecFluent<ProxyConfigSpecBuilder> implements VisitableBuilder<ProxyConfigSpec,ProxyConfigSpecBuilder>{
  public ProxyConfigSpecBuilder() {
    this(new ProxyConfigSpec());
  }
  
  public ProxyConfigSpecBuilder(ProxyConfigSpecFluent<?> fluent) {
    this(fluent, new ProxyConfigSpec());
  }
  
  public ProxyConfigSpecBuilder(ProxyConfigSpecFluent<?> fluent,ProxyConfigSpec instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ProxyConfigSpecBuilder(ProxyConfigSpec instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ProxyConfigSpecFluent<?> fluent;
  
  public ProxyConfigSpec build() {
    ProxyConfigSpec buildable = new ProxyConfigSpec(fluent.getConcurrency(),fluent.getEnvironmentVariables(),fluent.buildImage(),fluent.buildSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}