package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class LoadBalancerSettingsBuilder extends LoadBalancerSettingsFluent<LoadBalancerSettingsBuilder> implements VisitableBuilder<LoadBalancerSettings,LoadBalancerSettingsBuilder>{
  public LoadBalancerSettingsBuilder() {
    this(new LoadBalancerSettings());
  }
  
  public LoadBalancerSettingsBuilder(LoadBalancerSettingsFluent<?> fluent) {
    this(fluent, new LoadBalancerSettings());
  }
  
  public LoadBalancerSettingsBuilder(LoadBalancerSettingsFluent<?> fluent,LoadBalancerSettings instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public LoadBalancerSettingsBuilder(LoadBalancerSettings instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  LoadBalancerSettingsFluent<?> fluent;
  
  public LoadBalancerSettings build() {
    LoadBalancerSettings buildable = new LoadBalancerSettings(fluent.buildLbPolicy(),fluent.buildLocalityLbSetting(),fluent.getWarmupDurationSecs());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}