package io.fabric8.istio.api.networking.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Integer;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class IstioIngressListenerFluent<A extends IstioIngressListenerFluent<A>> extends BaseFluent<A>{
  public IstioIngressListenerFluent() {
  }
  
  public IstioIngressListenerFluent(IstioIngressListener instance) {
    this.copyInstance(instance);
  }
  private String bind;
  private CaptureMode captureMode;
  private ConnectionPoolSettingsBuilder connectionPool;
  private String defaultEndpoint;
  private SidecarPortBuilder port;
  private ServerTLSSettingsBuilder tls;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(IstioIngressListener instance) {
    instance = (instance != null ? instance : new IstioIngressListener());
    if (instance != null) {
          this.withBind(instance.getBind());
          this.withCaptureMode(instance.getCaptureMode());
          this.withConnectionPool(instance.getConnectionPool());
          this.withDefaultEndpoint(instance.getDefaultEndpoint());
          this.withPort(instance.getPort());
          this.withTls(instance.getTls());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getBind() {
    return this.bind;
  }
  
  public A withBind(String bind) {
    this.bind = bind;
    return (A) this;
  }
  
  public boolean hasBind() {
    return this.bind != null;
  }
  
  public CaptureMode getCaptureMode() {
    return this.captureMode;
  }
  
  public A withCaptureMode(CaptureMode captureMode) {
    this.captureMode = captureMode;
    return (A) this;
  }
  
  public boolean hasCaptureMode() {
    return this.captureMode != null;
  }
  
  public ConnectionPoolSettings buildConnectionPool() {
    return this.connectionPool != null ? this.connectionPool.build() : null;
  }
  
  public A withConnectionPool(ConnectionPoolSettings connectionPool) {
    this._visitables.remove("connectionPool");
    if (connectionPool != null) {
        this.connectionPool = new ConnectionPoolSettingsBuilder(connectionPool);
        this._visitables.get("connectionPool").add(this.connectionPool);
    } else {
        this.connectionPool = null;
        this._visitables.get("connectionPool").remove(this.connectionPool);
    }
    return (A) this;
  }
  
  public boolean hasConnectionPool() {
    return this.connectionPool != null;
  }
  
  public ConnectionPoolNested<A> withNewConnectionPool() {
    return new ConnectionPoolNested(null);
  }
  
  public ConnectionPoolNested<A> withNewConnectionPoolLike(ConnectionPoolSettings item) {
    return new ConnectionPoolNested(item);
  }
  
  public ConnectionPoolNested<A> editConnectionPool() {
    return withNewConnectionPoolLike(java.util.Optional.ofNullable(buildConnectionPool()).orElse(null));
  }
  
  public ConnectionPoolNested<A> editOrNewConnectionPool() {
    return withNewConnectionPoolLike(java.util.Optional.ofNullable(buildConnectionPool()).orElse(new ConnectionPoolSettingsBuilder().build()));
  }
  
  public ConnectionPoolNested<A> editOrNewConnectionPoolLike(ConnectionPoolSettings item) {
    return withNewConnectionPoolLike(java.util.Optional.ofNullable(buildConnectionPool()).orElse(item));
  }
  
  public String getDefaultEndpoint() {
    return this.defaultEndpoint;
  }
  
  public A withDefaultEndpoint(String defaultEndpoint) {
    this.defaultEndpoint = defaultEndpoint;
    return (A) this;
  }
  
  public boolean hasDefaultEndpoint() {
    return this.defaultEndpoint != null;
  }
  
  public SidecarPort buildPort() {
    return this.port != null ? this.port.build() : null;
  }
  
  public A withPort(SidecarPort port) {
    this._visitables.remove("port");
    if (port != null) {
        this.port = new SidecarPortBuilder(port);
        this._visitables.get("port").add(this.port);
    } else {
        this.port = null;
        this._visitables.get("port").remove(this.port);
    }
    return (A) this;
  }
  
  public boolean hasPort() {
    return this.port != null;
  }
  
  public A withNewPort(String name,Integer number,String protocol,Integer targetPort) {
    return (A)withPort(new SidecarPort(name, number, protocol, targetPort));
  }
  
  public PortNested<A> withNewPort() {
    return new PortNested(null);
  }
  
  public PortNested<A> withNewPortLike(SidecarPort item) {
    return new PortNested(item);
  }
  
  public PortNested<A> editPort() {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(null));
  }
  
  public PortNested<A> editOrNewPort() {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(new SidecarPortBuilder().build()));
  }
  
  public PortNested<A> editOrNewPortLike(SidecarPort item) {
    return withNewPortLike(java.util.Optional.ofNullable(buildPort()).orElse(item));
  }
  
  public ServerTLSSettings buildTls() {
    return this.tls != null ? this.tls.build() : null;
  }
  
  public A withTls(ServerTLSSettings tls) {
    this._visitables.remove("tls");
    if (tls != null) {
        this.tls = new ServerTLSSettingsBuilder(tls);
        this._visitables.get("tls").add(this.tls);
    } else {
        this.tls = null;
        this._visitables.get("tls").remove(this.tls);
    }
    return (A) this;
  }
  
  public boolean hasTls() {
    return this.tls != null;
  }
  
  public TlsNested<A> withNewTls() {
    return new TlsNested(null);
  }
  
  public TlsNested<A> withNewTlsLike(ServerTLSSettings item) {
    return new TlsNested(item);
  }
  
  public TlsNested<A> editTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(null));
  }
  
  public TlsNested<A> editOrNewTls() {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(new ServerTLSSettingsBuilder().build()));
  }
  
  public TlsNested<A> editOrNewTlsLike(ServerTLSSettings item) {
    return withNewTlsLike(java.util.Optional.ofNullable(buildTls()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    IstioIngressListenerFluent that = (IstioIngressListenerFluent) o;
    if (!java.util.Objects.equals(bind, that.bind)) return false;
    if (!java.util.Objects.equals(captureMode, that.captureMode)) return false;
    if (!java.util.Objects.equals(connectionPool, that.connectionPool)) return false;
    if (!java.util.Objects.equals(defaultEndpoint, that.defaultEndpoint)) return false;
    if (!java.util.Objects.equals(port, that.port)) return false;
    if (!java.util.Objects.equals(tls, that.tls)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(bind,  captureMode,  connectionPool,  defaultEndpoint,  port,  tls,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (bind != null) { sb.append("bind:"); sb.append(bind + ","); }
    if (captureMode != null) { sb.append("captureMode:"); sb.append(captureMode + ","); }
    if (connectionPool != null) { sb.append("connectionPool:"); sb.append(connectionPool + ","); }
    if (defaultEndpoint != null) { sb.append("defaultEndpoint:"); sb.append(defaultEndpoint + ","); }
    if (port != null) { sb.append("port:"); sb.append(port + ","); }
    if (tls != null) { sb.append("tls:"); sb.append(tls + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConnectionPoolNested<N> extends ConnectionPoolSettingsFluent<ConnectionPoolNested<N>> implements Nested<N>{
    ConnectionPoolNested(ConnectionPoolSettings item) {
      this.builder = new ConnectionPoolSettingsBuilder(this, item);
    }
    ConnectionPoolSettingsBuilder builder;
    
    public N and() {
      return (N) IstioIngressListenerFluent.this.withConnectionPool(builder.build());
    }
    
    public N endConnectionPool() {
      return and();
    }
    
  
  }
  public class PortNested<N> extends SidecarPortFluent<PortNested<N>> implements Nested<N>{
    PortNested(SidecarPort item) {
      this.builder = new SidecarPortBuilder(this, item);
    }
    SidecarPortBuilder builder;
    
    public N and() {
      return (N) IstioIngressListenerFluent.this.withPort(builder.build());
    }
    
    public N endPort() {
      return and();
    }
    
  
  }
  public class TlsNested<N> extends ServerTLSSettingsFluent<TlsNested<N>> implements Nested<N>{
    TlsNested(ServerTLSSettings item) {
      this.builder = new ServerTLSSettingsBuilder(this, item);
    }
    ServerTLSSettingsBuilder builder;
    
    public N and() {
      return (N) IstioIngressListenerFluent.this.withTls(builder.build());
    }
    
    public N endTls() {
      return and();
    }
    
  
  }

}