package io.fabric8.istio.api.networking.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPRewriteFluent<A extends HTTPRewriteFluent<A>> extends BaseFluent<A>{
  public HTTPRewriteFluent() {
  }
  
  public HTTPRewriteFluent(HTTPRewrite instance) {
    this.copyInstance(instance);
  }
  private String authority;
  private String uri;
  private RegexRewriteBuilder uriRegexRewrite;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HTTPRewrite instance) {
    instance = (instance != null ? instance : new HTTPRewrite());
    if (instance != null) {
          this.withAuthority(instance.getAuthority());
          this.withUri(instance.getUri());
          this.withUriRegexRewrite(instance.getUriRegexRewrite());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getAuthority() {
    return this.authority;
  }
  
  public A withAuthority(String authority) {
    this.authority = authority;
    return (A) this;
  }
  
  public boolean hasAuthority() {
    return this.authority != null;
  }
  
  public String getUri() {
    return this.uri;
  }
  
  public A withUri(String uri) {
    this.uri = uri;
    return (A) this;
  }
  
  public boolean hasUri() {
    return this.uri != null;
  }
  
  public RegexRewrite buildUriRegexRewrite() {
    return this.uriRegexRewrite != null ? this.uriRegexRewrite.build() : null;
  }
  
  public A withUriRegexRewrite(RegexRewrite uriRegexRewrite) {
    this._visitables.remove("uriRegexRewrite");
    if (uriRegexRewrite != null) {
        this.uriRegexRewrite = new RegexRewriteBuilder(uriRegexRewrite);
        this._visitables.get("uriRegexRewrite").add(this.uriRegexRewrite);
    } else {
        this.uriRegexRewrite = null;
        this._visitables.get("uriRegexRewrite").remove(this.uriRegexRewrite);
    }
    return (A) this;
  }
  
  public boolean hasUriRegexRewrite() {
    return this.uriRegexRewrite != null;
  }
  
  public A withNewUriRegexRewrite(String match,String rewrite) {
    return (A)withUriRegexRewrite(new RegexRewrite(match, rewrite));
  }
  
  public UriRegexRewriteNested<A> withNewUriRegexRewrite() {
    return new UriRegexRewriteNested(null);
  }
  
  public UriRegexRewriteNested<A> withNewUriRegexRewriteLike(RegexRewrite item) {
    return new UriRegexRewriteNested(item);
  }
  
  public UriRegexRewriteNested<A> editUriRegexRewrite() {
    return withNewUriRegexRewriteLike(java.util.Optional.ofNullable(buildUriRegexRewrite()).orElse(null));
  }
  
  public UriRegexRewriteNested<A> editOrNewUriRegexRewrite() {
    return withNewUriRegexRewriteLike(java.util.Optional.ofNullable(buildUriRegexRewrite()).orElse(new RegexRewriteBuilder().build()));
  }
  
  public UriRegexRewriteNested<A> editOrNewUriRegexRewriteLike(RegexRewrite item) {
    return withNewUriRegexRewriteLike(java.util.Optional.ofNullable(buildUriRegexRewrite()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPRewriteFluent that = (HTTPRewriteFluent) o;
    if (!java.util.Objects.equals(authority, that.authority)) return false;
    if (!java.util.Objects.equals(uri, that.uri)) return false;
    if (!java.util.Objects.equals(uriRegexRewrite, that.uriRegexRewrite)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(authority,  uri,  uriRegexRewrite,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (authority != null) { sb.append("authority:"); sb.append(authority + ","); }
    if (uri != null) { sb.append("uri:"); sb.append(uri + ","); }
    if (uriRegexRewrite != null) { sb.append("uriRegexRewrite:"); sb.append(uriRegexRewrite + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class UriRegexRewriteNested<N> extends RegexRewriteFluent<UriRegexRewriteNested<N>> implements Nested<N>{
    UriRegexRewriteNested(RegexRewrite item) {
      this.builder = new RegexRewriteBuilder(this, item);
    }
    RegexRewriteBuilder builder;
    
    public N and() {
      return (N) HTTPRewriteFluent.this.withUriRegexRewrite(builder.build());
    }
    
    public N endUriRegexRewrite() {
      return and();
    }
    
  
  }

}