package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class HTTPHeaderBuilder extends HTTPHeaderFluent<HTTPHeaderBuilder> implements VisitableBuilder<HTTPHeader,HTTPHeaderBuilder>{
  public HTTPHeaderBuilder() {
    this(new HTTPHeader());
  }
  
  public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent) {
    this(fluent, new HTTPHeader());
  }
  
  public HTTPHeaderBuilder(HTTPHeaderFluent<?> fluent,HTTPHeader instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public HTTPHeaderBuilder(HTTPHeader instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  HTTPHeaderFluent<?> fluent;
  
  public HTTPHeader build() {
    HTTPHeader buildable = new HTTPHeader(fluent.getName(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}