package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Double;
import java.lang.Integer;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPFaultInjectionDelayFluent<A extends HTTPFaultInjectionDelayFluent<A>> extends BaseFluent<A>{
  public HTTPFaultInjectionDelayFluent() {
  }
  
  public HTTPFaultInjectionDelayFluent(HTTPFaultInjectionDelay instance) {
    this.copyInstance(instance);
  }
  private VisitableBuilder<? extends IsHTTPFaultInjectionDelayHttpDelayType,?> httpDelayType;
  private Integer percent;
  private PercentBuilder percentage;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HTTPFaultInjectionDelay instance) {
    instance = (instance != null ? instance : new HTTPFaultInjectionDelay());
    if (instance != null) {
          this.withHttpDelayType(instance.getHttpDelayType());
          this.withPercent(instance.getPercent());
          this.withPercentage(instance.getPercentage());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public IsHTTPFaultInjectionDelayHttpDelayType buildHttpDelayType() {
    return this.httpDelayType != null ? this.httpDelayType.build() : null;
  }
  
  public A withHttpDelayType(IsHTTPFaultInjectionDelayHttpDelayType httpDelayType) {
    if (httpDelayType == null) {
        this.httpDelayType = null;
        this._visitables.remove("httpDelayType");
        return (A) this;
    } else {
        VisitableBuilder<? extends IsHTTPFaultInjectionDelayHttpDelayType,?> builder = builder(httpDelayType);;
        this._visitables.clear();
        this._visitables.get("httpDelayType").add(builder);
        this.httpDelayType = builder;
        return (A) this;
    }
  }
  
  public boolean hasHttpDelayType() {
    return this.httpDelayType != null;
  }
  
  public HTTPFaultInjectionDelayExponentialHttpTypeNested<A> withNewHTTPFaultInjectionDelayExponentialHttpType() {
    return new HTTPFaultInjectionDelayExponentialHttpTypeNested(null);
  }
  
  public HTTPFaultInjectionDelayExponentialHttpTypeNested<A> withNewHTTPFaultInjectionDelayExponentialHttpTypeLike(HTTPFaultInjectionDelayExponentialDelay item) {
    return new HTTPFaultInjectionDelayExponentialHttpTypeNested(item);
  }
  
  public A withNewHTTPFaultInjectionDelayExponentialHttpType(String exponentialDelay) {
    return (A)withHttpDelayType(new HTTPFaultInjectionDelayExponentialDelay(exponentialDelay));
  }
  
  public HTTPFaultInjectionDelayFixedHttpTypeNested<A> withNewHTTPFaultInjectionDelayFixedHttpType() {
    return new HTTPFaultInjectionDelayFixedHttpTypeNested(null);
  }
  
  public HTTPFaultInjectionDelayFixedHttpTypeNested<A> withNewHTTPFaultInjectionDelayFixedHttpTypeLike(HTTPFaultInjectionDelayFixedDelay item) {
    return new HTTPFaultInjectionDelayFixedHttpTypeNested(item);
  }
  
  public A withNewHTTPFaultInjectionDelayFixedHttpType(String fixedDelay) {
    return (A)withHttpDelayType(new HTTPFaultInjectionDelayFixedDelay(fixedDelay));
  }
  
  public Integer getPercent() {
    return this.percent;
  }
  
  public A withPercent(Integer percent) {
    this.percent = percent;
    return (A) this;
  }
  
  public boolean hasPercent() {
    return this.percent != null;
  }
  
  public Percent buildPercentage() {
    return this.percentage != null ? this.percentage.build() : null;
  }
  
  public A withPercentage(Percent percentage) {
    this._visitables.remove("percentage");
    if (percentage != null) {
        this.percentage = new PercentBuilder(percentage);
        this._visitables.get("percentage").add(this.percentage);
    } else {
        this.percentage = null;
        this._visitables.get("percentage").remove(this.percentage);
    }
    return (A) this;
  }
  
  public boolean hasPercentage() {
    return this.percentage != null;
  }
  
  public A withNewPercentage(Double value) {
    return (A)withPercentage(new Percent(value));
  }
  
  public PercentageNested<A> withNewPercentage() {
    return new PercentageNested(null);
  }
  
  public PercentageNested<A> withNewPercentageLike(Percent item) {
    return new PercentageNested(item);
  }
  
  public PercentageNested<A> editPercentage() {
    return withNewPercentageLike(java.util.Optional.ofNullable(buildPercentage()).orElse(null));
  }
  
  public PercentageNested<A> editOrNewPercentage() {
    return withNewPercentageLike(java.util.Optional.ofNullable(buildPercentage()).orElse(new PercentBuilder().build()));
  }
  
  public PercentageNested<A> editOrNewPercentageLike(Percent item) {
    return withNewPercentageLike(java.util.Optional.ofNullable(buildPercentage()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPFaultInjectionDelayFluent that = (HTTPFaultInjectionDelayFluent) o;
    if (!java.util.Objects.equals(httpDelayType, that.httpDelayType)) return false;
    if (!java.util.Objects.equals(percent, that.percent)) return false;
    if (!java.util.Objects.equals(percentage, that.percentage)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(httpDelayType,  percent,  percentage,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (httpDelayType != null) { sb.append("httpDelayType:"); sb.append(httpDelayType + ","); }
    if (percent != null) { sb.append("percent:"); sb.append(percent + ","); }
    if (percentage != null) { sb.append("percentage:"); sb.append(percentage + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.istio.api.networking.v1beta1."+"HTTPFaultInjectionDelayExponentialDelay": return (VisitableBuilder<T, ?>)new HTTPFaultInjectionDelayExponentialDelayBuilder((HTTPFaultInjectionDelayExponentialDelay) item);
    case "io.fabric8.istio.api.networking.v1beta1."+"HTTPFaultInjectionDelayFixedDelay": return (VisitableBuilder<T, ?>)new HTTPFaultInjectionDelayFixedDelayBuilder((HTTPFaultInjectionDelayFixedDelay) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class HTTPFaultInjectionDelayExponentialHttpTypeNested<N> extends HTTPFaultInjectionDelayExponentialDelayFluent<HTTPFaultInjectionDelayExponentialHttpTypeNested<N>> implements Nested<N>{
    HTTPFaultInjectionDelayExponentialHttpTypeNested(HTTPFaultInjectionDelayExponentialDelay item) {
      this.builder = new HTTPFaultInjectionDelayExponentialDelayBuilder(this, item);
    }
    HTTPFaultInjectionDelayExponentialDelayBuilder builder;
    
    public N and() {
      return (N) HTTPFaultInjectionDelayFluent.this.withHttpDelayType(builder.build());
    }
    
    public N endHTTPFaultInjectionDelayExponentialHttpType() {
      return and();
    }
    
  
  }
  public class HTTPFaultInjectionDelayFixedHttpTypeNested<N> extends HTTPFaultInjectionDelayFixedDelayFluent<HTTPFaultInjectionDelayFixedHttpTypeNested<N>> implements Nested<N>{
    HTTPFaultInjectionDelayFixedHttpTypeNested(HTTPFaultInjectionDelayFixedDelay item) {
      this.builder = new HTTPFaultInjectionDelayFixedDelayBuilder(this, item);
    }
    HTTPFaultInjectionDelayFixedDelayBuilder builder;
    
    public N and() {
      return (N) HTTPFaultInjectionDelayFluent.this.withHttpDelayType(builder.build());
    }
    
    public N endHTTPFaultInjectionDelayFixedHttpType() {
      return and();
    }
    
  
  }
  public class PercentageNested<N> extends PercentFluent<PercentageNested<N>> implements Nested<N>{
    PercentageNested(Percent item) {
      this.builder = new PercentBuilder(this, item);
    }
    PercentBuilder builder;
    
    public N and() {
      return (N) HTTPFaultInjectionDelayFluent.this.withPercentage(builder.build());
    }
    
    public N endPercentage() {
      return and();
    }
    
  
  }

}