package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class HTTPBodyFluent<A extends HTTPBodyFluent<A>> extends BaseFluent<A>{
  public HTTPBodyFluent() {
  }
  
  public HTTPBodyFluent(HTTPBody instance) {
    this.copyInstance(instance);
  }
  private VisitableBuilder<? extends IsHTTPBodySpecifier,?> specifier;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(HTTPBody instance) {
    instance = (instance != null ? instance : new HTTPBody());
    if (instance != null) {
          this.withSpecifier(instance.getSpecifier());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public IsHTTPBodySpecifier buildSpecifier() {
    return this.specifier != null ? this.specifier.build() : null;
  }
  
  public A withSpecifier(IsHTTPBodySpecifier specifier) {
    if (specifier == null) {
        this.specifier = null;
        this._visitables.remove("specifier");
        return (A) this;
    } else {
        VisitableBuilder<? extends IsHTTPBodySpecifier,?> builder = builder(specifier);;
        this._visitables.clear();
        this._visitables.get("specifier").add(builder);
        this.specifier = builder;
        return (A) this;
    }
  }
  
  public boolean hasSpecifier() {
    return this.specifier != null;
  }
  
  public HTTPBodyBytesSpecifierNested<A> withNewHTTPBodyBytesSpecifier() {
    return new HTTPBodyBytesSpecifierNested(null);
  }
  
  public HTTPBodyBytesSpecifierNested<A> withNewHTTPBodyBytesSpecifierLike(HTTPBodyBytes item) {
    return new HTTPBodyBytesSpecifierNested(item);
  }
  
  public A withNewHTTPBodyBytesSpecifier(String bytes) {
    return (A)withSpecifier(new HTTPBodyBytes(bytes));
  }
  
  public HTTPBodyStringSpecifierNested<A> withNewHTTPBodyStringSpecifier() {
    return new HTTPBodyStringSpecifierNested(null);
  }
  
  public HTTPBodyStringSpecifierNested<A> withNewHTTPBodyStringSpecifierLike(HTTPBodyString item) {
    return new HTTPBodyStringSpecifierNested(item);
  }
  
  public A withNewHTTPBodyStringSpecifier(String string) {
    return (A)withSpecifier(new HTTPBodyString(string));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    HTTPBodyFluent that = (HTTPBodyFluent) o;
    if (!java.util.Objects.equals(specifier, that.specifier)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(specifier,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (specifier != null) { sb.append("specifier:"); sb.append(specifier + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.istio.api.networking.v1beta1."+"HTTPBodyBytes": return (VisitableBuilder<T, ?>)new HTTPBodyBytesBuilder((HTTPBodyBytes) item);
    case "io.fabric8.istio.api.networking.v1beta1."+"HTTPBodyString": return (VisitableBuilder<T, ?>)new HTTPBodyStringBuilder((HTTPBodyString) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class HTTPBodyBytesSpecifierNested<N> extends HTTPBodyBytesFluent<HTTPBodyBytesSpecifierNested<N>> implements Nested<N>{
    HTTPBodyBytesSpecifierNested(HTTPBodyBytes item) {
      this.builder = new HTTPBodyBytesBuilder(this, item);
    }
    HTTPBodyBytesBuilder builder;
    
    public N and() {
      return (N) HTTPBodyFluent.this.withSpecifier(builder.build());
    }
    
    public N endHTTPBodyBytesSpecifier() {
      return and();
    }
    
  
  }
  public class HTTPBodyStringSpecifierNested<N> extends HTTPBodyStringFluent<HTTPBodyStringSpecifierNested<N>> implements Nested<N>{
    HTTPBodyStringSpecifierNested(HTTPBodyString item) {
      this.builder = new HTTPBodyStringBuilder(this, item);
    }
    HTTPBodyStringBuilder builder;
    
    public N and() {
      return (N) HTTPBodyFluent.this.withSpecifier(builder.build());
    }
    
    public N endHTTPBodyStringSpecifier() {
      return and();
    }
    
  
  }

}