package io.fabric8.istio.api.networking.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ConnectionPoolSettingsTCPSettingsFluent<A extends ConnectionPoolSettingsTCPSettingsFluent<A>> extends BaseFluent<A>{
  public ConnectionPoolSettingsTCPSettingsFluent() {
  }
  
  public ConnectionPoolSettingsTCPSettingsFluent(ConnectionPoolSettingsTCPSettings instance) {
    this.copyInstance(instance);
  }
  private String connectTimeout;
  private String idleTimeout;
  private String maxConnectionDuration;
  private Integer maxConnections;
  private ConnectionPoolSettingsTCPSettingsTcpKeepaliveBuilder tcpKeepalive;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ConnectionPoolSettingsTCPSettings instance) {
    instance = (instance != null ? instance : new ConnectionPoolSettingsTCPSettings());
    if (instance != null) {
          this.withConnectTimeout(instance.getConnectTimeout());
          this.withIdleTimeout(instance.getIdleTimeout());
          this.withMaxConnectionDuration(instance.getMaxConnectionDuration());
          this.withMaxConnections(instance.getMaxConnections());
          this.withTcpKeepalive(instance.getTcpKeepalive());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getConnectTimeout() {
    return this.connectTimeout;
  }
  
  public A withConnectTimeout(String connectTimeout) {
    this.connectTimeout = connectTimeout;
    return (A) this;
  }
  
  public boolean hasConnectTimeout() {
    return this.connectTimeout != null;
  }
  
  public String getIdleTimeout() {
    return this.idleTimeout;
  }
  
  public A withIdleTimeout(String idleTimeout) {
    this.idleTimeout = idleTimeout;
    return (A) this;
  }
  
  public boolean hasIdleTimeout() {
    return this.idleTimeout != null;
  }
  
  public String getMaxConnectionDuration() {
    return this.maxConnectionDuration;
  }
  
  public A withMaxConnectionDuration(String maxConnectionDuration) {
    this.maxConnectionDuration = maxConnectionDuration;
    return (A) this;
  }
  
  public boolean hasMaxConnectionDuration() {
    return this.maxConnectionDuration != null;
  }
  
  public Integer getMaxConnections() {
    return this.maxConnections;
  }
  
  public A withMaxConnections(Integer maxConnections) {
    this.maxConnections = maxConnections;
    return (A) this;
  }
  
  public boolean hasMaxConnections() {
    return this.maxConnections != null;
  }
  
  public ConnectionPoolSettingsTCPSettingsTcpKeepalive buildTcpKeepalive() {
    return this.tcpKeepalive != null ? this.tcpKeepalive.build() : null;
  }
  
  public A withTcpKeepalive(ConnectionPoolSettingsTCPSettingsTcpKeepalive tcpKeepalive) {
    this._visitables.remove("tcpKeepalive");
    if (tcpKeepalive != null) {
        this.tcpKeepalive = new ConnectionPoolSettingsTCPSettingsTcpKeepaliveBuilder(tcpKeepalive);
        this._visitables.get("tcpKeepalive").add(this.tcpKeepalive);
    } else {
        this.tcpKeepalive = null;
        this._visitables.get("tcpKeepalive").remove(this.tcpKeepalive);
    }
    return (A) this;
  }
  
  public boolean hasTcpKeepalive() {
    return this.tcpKeepalive != null;
  }
  
  public A withNewTcpKeepalive(String interval,Integer probes,String time) {
    return (A)withTcpKeepalive(new ConnectionPoolSettingsTCPSettingsTcpKeepalive(interval, probes, time));
  }
  
  public TcpKeepaliveNested<A> withNewTcpKeepalive() {
    return new TcpKeepaliveNested(null);
  }
  
  public TcpKeepaliveNested<A> withNewTcpKeepaliveLike(ConnectionPoolSettingsTCPSettingsTcpKeepalive item) {
    return new TcpKeepaliveNested(item);
  }
  
  public TcpKeepaliveNested<A> editTcpKeepalive() {
    return withNewTcpKeepaliveLike(java.util.Optional.ofNullable(buildTcpKeepalive()).orElse(null));
  }
  
  public TcpKeepaliveNested<A> editOrNewTcpKeepalive() {
    return withNewTcpKeepaliveLike(java.util.Optional.ofNullable(buildTcpKeepalive()).orElse(new ConnectionPoolSettingsTCPSettingsTcpKeepaliveBuilder().build()));
  }
  
  public TcpKeepaliveNested<A> editOrNewTcpKeepaliveLike(ConnectionPoolSettingsTCPSettingsTcpKeepalive item) {
    return withNewTcpKeepaliveLike(java.util.Optional.ofNullable(buildTcpKeepalive()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ConnectionPoolSettingsTCPSettingsFluent that = (ConnectionPoolSettingsTCPSettingsFluent) o;
    if (!java.util.Objects.equals(connectTimeout, that.connectTimeout)) return false;
    if (!java.util.Objects.equals(idleTimeout, that.idleTimeout)) return false;
    if (!java.util.Objects.equals(maxConnectionDuration, that.maxConnectionDuration)) return false;
    if (!java.util.Objects.equals(maxConnections, that.maxConnections)) return false;
    if (!java.util.Objects.equals(tcpKeepalive, that.tcpKeepalive)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(connectTimeout,  idleTimeout,  maxConnectionDuration,  maxConnections,  tcpKeepalive,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (connectTimeout != null) { sb.append("connectTimeout:"); sb.append(connectTimeout + ","); }
    if (idleTimeout != null) { sb.append("idleTimeout:"); sb.append(idleTimeout + ","); }
    if (maxConnectionDuration != null) { sb.append("maxConnectionDuration:"); sb.append(maxConnectionDuration + ","); }
    if (maxConnections != null) { sb.append("maxConnections:"); sb.append(maxConnections + ","); }
    if (tcpKeepalive != null) { sb.append("tcpKeepalive:"); sb.append(tcpKeepalive + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class TcpKeepaliveNested<N> extends ConnectionPoolSettingsTCPSettingsTcpKeepaliveFluent<TcpKeepaliveNested<N>> implements Nested<N>{
    TcpKeepaliveNested(ConnectionPoolSettingsTCPSettingsTcpKeepalive item) {
      this.builder = new ConnectionPoolSettingsTCPSettingsTcpKeepaliveBuilder(this, item);
    }
    ConnectionPoolSettingsTCPSettingsTcpKeepaliveBuilder builder;
    
    public N and() {
      return (N) ConnectionPoolSettingsTCPSettingsFluent.this.withTcpKeepalive(builder.build());
    }
    
    public N endTcpKeepalive() {
      return and();
    }
    
  
  }

}