package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConnectionPoolSettingsBuilder extends ConnectionPoolSettingsFluent<ConnectionPoolSettingsBuilder> implements VisitableBuilder<ConnectionPoolSettings,ConnectionPoolSettingsBuilder>{
  public ConnectionPoolSettingsBuilder() {
    this(new ConnectionPoolSettings());
  }
  
  public ConnectionPoolSettingsBuilder(ConnectionPoolSettingsFluent<?> fluent) {
    this(fluent, new ConnectionPoolSettings());
  }
  
  public ConnectionPoolSettingsBuilder(ConnectionPoolSettingsFluent<?> fluent,ConnectionPoolSettings instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConnectionPoolSettingsBuilder(ConnectionPoolSettings instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConnectionPoolSettingsFluent<?> fluent;
  
  public ConnectionPoolSettings build() {
    ConnectionPoolSettings buildable = new ConnectionPoolSettings(fluent.buildHttp(),fluent.buildTcp());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}