package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ConnectionPoolSettingsHTTPSettingsBuilder extends ConnectionPoolSettingsHTTPSettingsFluent<ConnectionPoolSettingsHTTPSettingsBuilder> implements VisitableBuilder<ConnectionPoolSettingsHTTPSettings,ConnectionPoolSettingsHTTPSettingsBuilder>{
  public ConnectionPoolSettingsHTTPSettingsBuilder() {
    this(new ConnectionPoolSettingsHTTPSettings());
  }
  
  public ConnectionPoolSettingsHTTPSettingsBuilder(ConnectionPoolSettingsHTTPSettingsFluent<?> fluent) {
    this(fluent, new ConnectionPoolSettingsHTTPSettings());
  }
  
  public ConnectionPoolSettingsHTTPSettingsBuilder(ConnectionPoolSettingsHTTPSettingsFluent<?> fluent,ConnectionPoolSettingsHTTPSettings instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ConnectionPoolSettingsHTTPSettingsBuilder(ConnectionPoolSettingsHTTPSettings instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ConnectionPoolSettingsHTTPSettingsFluent<?> fluent;
  
  public ConnectionPoolSettingsHTTPSettings build() {
    ConnectionPoolSettingsHTTPSettings buildable = new ConnectionPoolSettingsHTTPSettings(fluent.getH2UpgradePolicy(),fluent.getHttp1MaxPendingRequests(),fluent.getHttp2MaxRequests(),fluent.getIdleTimeout(),fluent.getMaxRequestsPerConnection(),fluent.getMaxRetries(),fluent.getUseClientProtocol());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}