package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class RouteDestinationBuilder extends RouteDestinationFluent<RouteDestinationBuilder> implements VisitableBuilder<RouteDestination,RouteDestinationBuilder>{
  public RouteDestinationBuilder() {
    this(new RouteDestination());
  }
  
  public RouteDestinationBuilder(RouteDestinationFluent<?> fluent) {
    this(fluent, new RouteDestination());
  }
  
  public RouteDestinationBuilder(RouteDestinationFluent<?> fluent,RouteDestination instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public RouteDestinationBuilder(RouteDestination instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  RouteDestinationFluent<?> fluent;
  
  public RouteDestination build() {
    RouteDestination buildable = new RouteDestination(fluent.buildDestination(),fluent.getWeight());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}